<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format name="european" decimal-separator=',' grouping-separator='.' />
 <xsl:template match="/">
<html>
<head>
	<title>CONTO DEL BILANCIO PER COMUNI</title>
	
<style type="text/css">
td { font-family: tahoma; font-size: 7pt; color: #000000; font-weight: normal;}
table.tabella1 { width: 1096px; border-collapse: collapse; border-width: 0}
td.indent1 {padding-left: 15px}
td.stampa1 { width: 84px }
td.stampa2 { width: 50px }
</style>
<style media="print" type="text/css">
td { font-family: tahoma; font-size: 5pt; color: #000000; }
table.tabella1 { width: 886px }
td.stampa1 { width: 64px }
td.stampa2 { width: 40px }
</style>

</head>
<body bgcolor="#FFFFFF" text="#000000">

<table width="100%" border="0" cellspacing="0" cellpadding="3">
  <tr> 
    <td align="center" colspan="3" class="intest"> 
	      <p>
		      <b>CONTO DEL BILANCIO<br /></b>
		      <b>PER COMUNI<br /></b>
	      </p>
      </td>
  </tr>
  <tr> 
    <td width="290">ESERCIZIO: <xsl:value-of select="//Copertina/Esercizio"/> </td>
    <td width="466">ENTE: <xsl:value-of select="//Copertina/NomeEnte"/></td>
    <td width="229">SIGLA PROVINCIA: <xsl:value-of select="//Copertina/Provincia"/></td>
  </tr>
  <tr> 
    <td width="290">CODICE ISTAT: <xsl:value-of select="//Copertina/CodiceIstat"/>
</td>
    <td width="466">DELIBERA DI APPROVAZIONE: N°<xsl:value-of select="//Copertina/NumDelibera"/></td>
    <xsl:variable name="abitanti"  select ="//Copertina/NumAbitanti" />
    <td width="229">NUMERO DI ABITANTI: <xsl:value-of select ="format-number ($abitanti, '#.###.###.###.###.##0', 'european') "/>
    </td>
  </tr>
  <tr> 
    <td width="290">PARTITA IVA: <xsl:value-of select="//Copertina/PartitaIVA"/></td>
    <td width="466">DEL: <xsl:value-of select="//Copertina/DataDelibera/Giorno"/>/<xsl:value-of select="//Copertina/DataDelibera/Mese"/>/<xsl:value-of select="//Copertina/DataDelibera/Anno"/></td>
    	
    <xsl:variable name="superficie"  select ="//Copertina/Superficie" />
    <td width="229">
    SUPERFICIE (kmq): <xsl:value-of select ="//Copertina/Superficie"/>
    </td>
  </tr>
</table><br/>
<table width="100%" border="0" cellspacing="0" cellpadding="3">
  <tr> 
    <td align="center"><b>QUADRO GENERALE RIASSUNTIVO DELLE SPESE</b></td>
  </tr>
</table>
<table class="tabella1" border="1" cellspacing="0" cellpadding="2" bordercolor="#000000">
  <tr> 
    <td rowspan="3" align="center" width="190">SPESE</td>
    <td colspan="8" align="center">Competenza</td>
    <td colspan="4" align="center">Residui</td>
  </tr>
  <tr> 
    <td align="center" rowspan="2" valign="middle">Previsioni iniziali</td>
    <td align="center" rowspan="2" valign="middle">Previsioni definitive</td>
    <td align="center" rowspan="2" valign="middle">% di definizione</td>
    <td align="center" colspan="2">Impegni</td>
    <td align="center" rowspan="2" valign="middle">Pagamenti</td>
    <td align="center" rowspan="2" valign="middle">% di realizz.ne</td>
    <td align="center" rowspan="2" valign="middle">Residui dalla competenza</td>
    <td align="center" rowspan="2" valign="middle">Conservati</td>
    <td align="center" rowspan="2" valign="middle">Pagati</td>
    <td align="center" rowspan="2" valign="middle">% di realizz.ne</td>
    <td align="center" rowspan="2" valign="middle">Rimasti</td>
  </tr>
  <tr> 
    <td align="center" valign="middle">Totale</td>
    <td align="center" valign="middle">Di cui spese correlate alle entrate</td>
  </tr>
  <tr> 
    <td align="center" width="190">1</td>
    <td align="center" class="stampa1">2</td>
    <td align="center" class="stampa1">3</td>
    <td align="center" class="stampa1">4</td>
    <td align="center" class="stampa1">5</td>
    <td align="center" class="stampa1">6</td>
    <td align="center" class="stampa1">7</td>
    <td align="center" class="stampa1">8</td>
    <td align="center" class="stampa1">9</td>
    <td align="center" class="stampa1">10</td>
    <td align="center" class="stampa1">11</td>
    <td align="center" class="stampa1">1<span class="stampa1">2</span></td>
    <td align="center" class="stampa1">13</td>
  </tr>
<tr> 
	<td width="190">Titolo I - Spese correnti</td>
		<xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/TotaleSpese/TotaleSpeseFinali/TitoloI" />
		</xsl:call-template> 
</tr>
<tr> 
	<td width="190">Titolo II - Spese in conto capitale</td>
	<xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/TotaleSpese/TotaleSpeseFinali/TitoloII" />
	</xsl:call-template> 
</tr>

<tr> 
	<td align="right" width="190">TOTALE SPESE FINALI</td>
	<xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/TotaleSpese/TotaleSpeseFinali/Totale" />
	</xsl:call-template> 

</tr>

<tr> 
	<td width="190">Titolo III - Spese per rimborso di prestiti</td>
	<xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/TotaleSpese/TitoloIII" />
	</xsl:call-template> 

</tr>

<tr> 
	<td width="190">Titolo IV - Spese per servizi per conto di terzi</td>
	<xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/TotaleSpese/TitoloIV" />
	</xsl:call-template> 

</tr>

<tr> 
	<td align="right" width="190">TOTALE</td>
	<xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/TotaleSpese/Totale" />
	</xsl:call-template> 

</tr>

<tr> 
	<td width="190">Disavanzo di amministrazione</td>
	<xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/Disavanzo" />
	</xsl:call-template> 

</tr>

<tr> 
	<td align="right" width="190">TOTALE COMPLESSIVO DELLE SPESE</td>
	<xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/TotaleComplessivo" />
	</xsl:call-template> 

</tr>
</table>


</body>
</html>

	
</xsl:template>
<xsl:template name="Formatta">
	<xsl:param name="imp" />
	<xsl:param name="PrevisioniIniziali"  select="$imp/PrevisioniIniziali"/>  
	<xsl:param name="imp1" select="translate($PrevisioniIniziali,  ','  , '.' ) "/>
	<xsl:param  name="imp2" select ="number($imp1)" />
	
	<td align="right" valign="bottom">	
		<xsl:value-of select ="format-number ($imp2, '#.###.###.###.###.##0,00', 'european') "/>
	</td>
	<td align="right" valign="bottom">&nbsp;</td>
	<td align="right" valign="bottom">&nbsp;</td>
	<td align="right" valign="bottom">&nbsp;</td>
	<td align="right" valign="bottom">&nbsp;</td>
	<td align="right" valign="bottom">&nbsp;</td>
	<td align="right" valign="bottom">&nbsp;</td>
	<td align="right" valign="bottom">&nbsp;</td>
	<td align="right" valign="bottom">&nbsp;</td>
	<td align="right" valign="bottom">&nbsp;</td>
	<td align="right" valign="bottom">&nbsp;</td>
	<td align="right" valign="bottom">&nbsp;</td>

</xsl:template>	
    
</xsl:stylesheet>
