<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format name="european" decimal-separator=',' grouping-separator='.' />
 <xsl:template match="/">
<html>
<head>
	<title>CONTO DEL BILANCIO PER COMUNI</title>
	
<style type="text/css">

	td { font-family: tahoma; font-size: 7pt; color: #000000; font-weight: normal;}
	table.tabella1 { width: 1012px; border-collapse: collapse; border-width: 0}
	td.indent1 {padding-left: 15px}
	td.stampa1 { width: 84px }
	td.stampa2 { width: 50px }
</style>
<style media="print" type="text/css">

	td { font-family: tahoma; font-size: 5pt; color: #000000; }
	table.tabella1 { width: 822px }
	td.stampa1 { width: 64px }
	td.stampa2 { width: 40px }
</style>

	
	
</head>
<body bgcolor="#FFFFFF" text="#000000">
<table width="100%" border="0" cellspacing="0" cellpadding="3">
  <tr> 
    <td align="center" colspan="3" class="intest"> 
	      <p>
		      <b>CONTO DEL BILANCIO<br /></b>
		      <b>PER COMUNI<br /></b>
	      </p>
      </td>
  </tr>
  <tr> 
    <td width="290">ESERCIZIO: <xsl:value-of select="//Copertina/Esercizio"/> </td>
    <td width="466">ENTE: <xsl:value-of select="//Copertina/NomeEnte"/></td>
    <td width="229">SIGLA PROVINCIA: <xsl:value-of select="//Copertina/Provincia"/></td>
  </tr>
  <tr> 
    <td width="290">CODICE ISTAT: <xsl:value-of select="//Copertina/CodiceIstat"/>
</td>
    <td width="466">DELIBERA DI APPROVAZIONE: N°<xsl:value-of select="//Copertina/NumDelibera"/></td>
    <xsl:variable name="abitanti"  select ="//Copertina/NumAbitanti" />
    <td width="229">NUMERO DI ABITANTI: <xsl:value-of select ="format-number ($abitanti, '#.###.###.###.###.##0', 'european') "/>
    </td>
  </tr>
  <tr> 
    <td width="290">PARTITA IVA: <xsl:value-of select="//Copertina/PartitaIVA"/></td>
    <td width="466">DEL: <xsl:value-of select="//Copertina/DataDelibera/Giorno"/>/<xsl:value-of select="//Copertina/DataDelibera/Mese"/>/<xsl:value-of select="//Copertina/DataDelibera/Anno"/></td>
    	
    <xsl:variable name="superficie"  select ="//Copertina/Superficie" />
    <td width="229">
    SUPERFICIE (kmq): <xsl:value-of select ="//Copertina/Superficie"/>
    </td>
  </tr>
</table><br/>
<table width="100%" border="0" cellspacing="0" cellpadding="3">
  <tr> 
    <td align="center"><b>QUADRO GENERALE RIASSUNTIVO DELLE ENTRATE</b></td>
  </tr>
</table>

<table class="tabella1" border="1" cellspacing="0" cellpadding="2" bordercolor="#000000">
	<tr> 
		<td rowspan="2" align="center" width="190">ENTRATE</td>
		<td colspan="7"   align="center">Competenza</td>
		<td colspan="4"   align="center">Residui</td>
  	</tr>
  	 <tr> 
		<td align="center" valign="middle">Previsioni iniziali</td>
		<td align="center" valign="middle">Previsioni definitive</td>
		<td align="center" valign="middle">% di definizione</td>
		<td align="center" valign="middle">Accertamenti</td>
		<td align="center" valign="middle">Riscossioni</td>
		<td align="center" valign="middle">% di realizz.ne</td>
		<td align="center" valign="middle">Residui dalla competenza</td>
		<td align="center" valign="middle">Conservati</td>
		<td align="center" valign="middle">Riscossi</td>
		<td align="center" valign="middle">% di realizz.ne</td>
		<td align="center" valign="middle">Rimasti</td>
 	 </tr>
 	 <tr> 
		<td align="center" width="190" class="unos">1</td>
		<td align="center" class="stampa1">2</td>
		<td align="center" class="stampa1">3</td>
		<td align="center" class="stampa2">4</td>
		<td align="center" class="stampa1">5</td>
		<td align="center" class="stampa1">6</td>
		<td align="center" class="stampa2">7</td>
		<td align="center" class="stampa1">8</td>
		<td align="center" class="stampa1">9</td>
		<td align="center" class="stampa1">10</td>
		<td align="center" class="stampa2">11</td>
		<td align="center" class="stampa1">12</td>
 	  </tr>
<tr> 
	<td width="190">Titolo I - Entrate tributarie</td>
		<xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/TotaleEntrate/TotaleEntrateFinali/TitoloI" />
		</xsl:call-template> 
</tr>
<tr>
	<td width="190">Titolo II - Entrate derivanti da contributi e trasferimenti 
	correnti dello Stato, della regione e di altri enti pubblici anche in rapporto 
	all'esercizio di funzioni delegate dalla regione</td>
		<xsl:call-template name="Formatta">
		<xsl:with-param name="imp" select="//QuadroGenerale/TotaleEntrate/TotaleEntrateFinali/TitoloII" />
		</xsl:call-template>      
</tr>
<tr>
	<td width="190">Titolo III - Entrate extratributarie</td>
		<xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/TotaleEntrate/TotaleEntrateFinali/TitoloIII" />
		</xsl:call-template>       
</tr>
<tr> 
	<td width="190">Titolo IV - Entrate derivanti da alienazioni, da trasferimenti 
	 di capitale e da riscossioni di crediti</td>
		<xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/TotaleEntrate/TotaleEntrateFinali/TitoloIV" />
		</xsl:call-template>     
</tr>
<tr> 
    <td align="right"  width="190">TOTALE ENTRATE FINALI</td>
	    <xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/TotaleEntrate/TotaleEntrateFinali/Totale" />
	    </xsl:call-template> 
</tr>
<tr>
	<td width="190">Titolo V - Entrate derivanti da accensioni di prestiti</td>
		<xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/TotaleEntrate/TitoloV" />
		</xsl:call-template>     
</tr>
<tr> 
	<td width="190">Titolo VI - Entrate da servizi per conto di terzi</td>
		<xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/TotaleEntrate/TitoloVI" />
		</xsl:call-template> 
</tr>
<tr> 
	<td align="right"  width="190">TOTALE</td>
		<xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/TotaleEntrate/Totale" />
		</xsl:call-template>      
</tr>
<tr> 
	<td width="190">Avanzo di amministrazione</td>
		<xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/Avanzo" />
		</xsl:call-template>      
</tr>
<tr> 
	<td width="190">Fondo di cassa al primo gennaio</td>
		<xsl:call-template name="Formatta">
			<xsl:with-param name="imp" select="//QuadroGenerale/Fondo" />
		</xsl:call-template> 
</tr>
 <tr> 
    <td align="right" width="190">TOTALE COMPLESSIVO DELLE ENTRATE</td>
    <xsl:call-template name="Formatta">
		<xsl:with-param name="imp" select="//QuadroGenerale/TotaleComplessivo" />
	</xsl:call-template> 
  </tr>
</table>
</body>
</html>

</xsl:template>
<xsl:template name="Formatta">
	   <xsl:param name="imp" />
	   <xsl:param name="PrevisioniIniziali"  select="$imp/PrevisioniIniziali"/>  
	   <xsl:param name="imp1" select="translate($PrevisioniIniziali,  ','  , '.' ) "/>
	   <xsl:param  name="imp2" select ="number($imp1)" />
	   <td align="right" valign="bottom">
	   		<xsl:value-of select ="format-number ($imp2, '#.###.###.###.###.##0,00', 'european') "/>
	   </td>
	   <td align="right" valign="bottom">&nbsp;</td>
    	   <td align="right" valign="bottom">&nbsp;</td>
    <td align="right" valign="bottom">&nbsp;</td>
    <td align="right" valign="bottom">&nbsp;</td>
    <td align="right" valign="bottom">&nbsp;</td>
    <td align="right" valign="bottom">&nbsp;</td>
    <td align="right" valign="bottom">&nbsp;</td>
    <td align="right" valign="bottom">&nbsp;</td>
    <td align="right" valign="bottom">&nbsp;</td>
    <td align="right" valign="bottom">&nbsp;</td>
     </xsl:template>	
    
</xsl:stylesheet>
