<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html"/>
	<xsl:decimal-format name="european" decimal-separator="," grouping-separator="."/>
	<xsl:template match="/">
		<html>
			<head>
				<title>CONTO DEL BILANCIO PER COMUNI</title>
				<style type="text/css">
	td { font-family: tahoma; font-size: 7pt; color: #000000; font-weight: normal;}
	td.intest { font-size: 9pt;}
	table.tabella1 { width: 849px; border-collapse: collapse; border-width: 0}
	td.indent1 {padding-left: 15px}
	td.indent2 {padding-left: 30px}
	td.stampa1 { width: 84px }
</style>
				<style media="print" type="text/css">
	td { font-family: tahoma; font-size: 5pt; color: #000000; }
	table.tabella1 { width: 729px }
	td.stampa1 { width: 64px }
</style>

		</head>
			<body bgcolor="#FFFFFF" text="#000000">
				<xsl:apply-templates select="//ContoEconomico/Copertina"/>
				<table border="0" cellspacing="0" cellpadding="3" class="tabella1">
  					<tr>
    					<td align="center"><b>CONTO ECONOMICO</b></td>
  					</tr>
				</table>
				<table class="tabella1" border="1" cellspacing="0" cellpadding="2" bordercolor="#000000">
 					 <tr>
  					  	<td align="center" rowspan="2">&nbsp;</td>
 						<td align="center" class="stampa1" rowspan="2">IMPORTI PARZIALI</td>
    					<td align="center" valign="middle" class="stampa1" rowspan="2">IMPORTI TOTALI</td>
    					<td align="center" class="stampa1" rowspan="2">IMPORTI COMPLESSIVI</td>
					</tr>
	 				 <tr> </tr>
					<xsl:apply-templates select="//ContoEconomico/Proventi"/>
					 <tr>
    					<td>&nbsp;</td>
    					<td align="right" valign="bottom">&nbsp;</td>
   						<td align="right" valign="bottom">&nbsp;</td>
    					<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<xsl:apply-templates select="//ContoEconomico/Costi"/>
					 <tr>
    					<td>&nbsp;</td>
    					<td align="right" valign="bottom">&nbsp;</td>
   						<td align="right" valign="bottom">&nbsp;</td>
    					<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<xsl:apply-templates select="//ContoEconomico/ProOneriSpecPar"/>
					 <tr>
    					<td>&nbsp;</td>
    					<td align="right" valign="bottom">&nbsp;</td>
   						<td align="right" valign="bottom">&nbsp;</td>
    					<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<xsl:apply-templates select="//ContoEconomico/ProvOneriFin"/>
					 <tr>
    					<td>&nbsp;</td>
    					<td align="right" valign="bottom">&nbsp;</td>
   						<td align="right" valign="bottom">&nbsp;</td>
    					<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<xsl:apply-templates select="//ContoEconomico/ProvOneriStra"/>
		          	<tr>
           	 			<td>
 		             	<b>RISULTATO ECONOMICO DELL&apos;ESERCIZIO (A-B+/-C+/-D+/-E)</b>
  		          		</td>
	
 			           	<td align="right" valign="bottom">&nbsp;</td>
	
 		           		<td align="right" valign="bottom">&nbsp;</td>
			    		<xsl:call-template name="formatto" >
   				 			<xsl:with-param name="Importo">
        						<xsl:value-of select="//ContoEconomico/RisultatoEconomico"/>
    						</xsl:with-param>
    					</xsl:call-template>



		          	</tr>


				</table>
		   	     <table width="640" border="0" cellspacing="0" cellpadding="5">
  			        <tr>
 	  		         <td colspan="2">
	     		         <p>&nbsp;</p>

			              <p>--------------------------------------------------------------------------, li --------------------------</p>
	 		             <p>&nbsp;</p>

			            </td>

		 	         </tr>
	
 		      	   	<tr>
   	      				<td align="center" width="264">IL SEGRETARIO
     			         <p>------------------------</p>
    	   		     	</td>
  	      		   		<td align="center" width="356">
  	         			<p>IL RESPONSABILE DEL SERVIZIO FINANZIARIO</p>
 	             		<p>--------------------------------------------------------------------------</p>
		            	</td>

	          		</tr>

	    	      	<tr>
   	         			<td colspan="2" align="center">
  	            		<p>IL LEGALE RAPPRESENTANTE DELL'ENTE</p>
 	             		<p>----------------------------------------------</p>
	            		</td>

	          		</tr>

	        	</table>

		</body>
	</html>
	</xsl:template>
	<xsl:template match="Copertina">
		<table width="100%" border="0" cellspacing="0" cellpadding="3">
			<tr>
				<td align="center" colspan="3" class="intest">
					<p>
						<b><br/>
						</b>
						<b><br/>
						</b>
					</p>
				</td>
			</tr>
			<tr>
				<td width="290">ESERCIZIO: <xsl:value-of select="//Copertina/Esercizio"/> </td>
			    <td width="466">ENTE: <xsl:value-of select="//Copertina/NomeEnte"/></td>
			    <td width="229">SIGLA PROVINCIA: <xsl:value-of select="//Copertina/Provincia"/></td>
			  </tr>
			  <tr> 
			    <td width="290">CODICE ISTAT: <xsl:value-of select="//Copertina/CodiceIstat"/>
			</td>
			    <td width="466">DELIBERA DI APPROVAZIONE: N°<xsl:value-of select="//Copertina/NumDelibera"/></td>
			    <xsl:variable name="abitanti"  select ="//Copertina/NumAbitanti" />
			    <td width="229">NUMERO DI ABITANTI: <xsl:value-of select ="format-number ($abitanti, '#.###.###.###.###.##0', 		'european') 	"/>
			    </td>
			  </tr>
			  <tr> 
			    <td width="290">PARTITA IVA: <xsl:value-of select="//Copertina/PartitaIVA"/></td>
			    <td width="466">DEL: <xsl:value-of select="//Copertina/DataDelibera/Giorno"/>/<xsl:value-of 			select="//Copertina/DataDelibera/Mese"/>/<xsl:value-of select="//Copertina/DataDelibera/Anno"/></td>
			    	
			    <xsl:variable name="superficie"  select ="//Copertina/Superficie" />
			    <td width="229">
			    SUPERFICIE (kmq): <xsl:value-of select ="//Copertina/Superficie"/>
		    </td>

			</tr>
		</table>
		<br/>
	</xsl:template>
<xsl:template match="Proventi">
		<tr>
    		<td><b>A) <u>PROVENTI DELLA GESTIONE</u></b></td>
    		<td align="right" valign="bottom">&nbsp;</td>
    		<td align="right" valign="bottom">&nbsp;</td>
    		<td align="right" valign="bottom">&nbsp;</td>
  		</tr>
  		<tr>
	 		<td class="indent1">1) Proventi tributari<u></u></td>
    		<xsl:call-template name="formatto" >
    		<xsl:with-param name="Importo">	 		
    		<xsl:value-of select="Tributari"/>
    		</xsl:with-param>
    		</xsl:call-template>
    		<td align="right" valign="bottom">&nbsp;</td>
    		<td align="right" valign="bottom">&nbsp;</td>
 		 </tr>
 		 <tr>
	 		<td class="indent1">2) Proventi da trasferimenti<u></u></td>
    		<xsl:call-template name="formatto" >
    		<xsl:with-param name="Importo">
    		<xsl:value-of select="Trasferimenti"/>
    		</xsl:with-param>
    		</xsl:call-template>
    		<td align="right" valign="bottom">&nbsp;</td>
    		<td align="right" valign="bottom">&nbsp;</td>
 		 </tr>
 		 <tr>
	 		<td class="indent1">3) Proventi da servizi pubblici<u></u></td>
    		<xsl:call-template name="formatto" >
    		<xsl:with-param name="Importo">
    		<xsl:value-of select="ServiziPubblici"/>
    		</xsl:with-param>
    		</xsl:call-template>
    		<td align="right" valign="bottom">&nbsp;</td>
    		<td align="right" valign="bottom">&nbsp;</td>
 		 </tr>
 		 <tr>
    <td class="indent1">4) Proventi da gestione patrimoniale</td>
    	<xsl:call-template name="formatto" >
    		<xsl:with-param name="Importo">
    		<xsl:value-of select="GestionePatrimoniale"/>
    		</xsl:with-param>
    		</xsl:call-template>
    <td align="right" valign="bottom">&nbsp;</td>
    <td align="right" valign="bottom">&nbsp;</td>
  </tr>
  <tr>
    <td class="indent1">5) Proventi diversi<u></u></td>
       	<xsl:call-template name="formatto" >
   		<xsl:with-param name="Importo">
   		<xsl:value-of select="ProventiDiversi"/>
   		</xsl:with-param>
   		</xsl:call-template>
    <td align="right" valign="bottom">&nbsp;</td>
    <td align="right" valign="bottom">&nbsp;</td>
  </tr>
  <tr>
    <td class="indent1">6) Proventi da concessioni di edificare</td>
       	<xsl:call-template name="formatto" >
   		<xsl:with-param name="Importo">
   		<xsl:value-of select="Concessioni"/>
   		</xsl:with-param>
   		</xsl:call-template>

    <td align="right" valign="bottom">&nbsp;</td>
    <td align="right" valign="bottom">&nbsp;</td>
  </tr>
  <tr>
    <td class="indent1">7) Incrementi di immobilizzazioni per lavori interni</td>
       	<xsl:call-template name="formatto" >
   		<xsl:with-param name="Importo">
   		<xsl:value-of select="IncrementiImmobilizzazioni"/>
   		</xsl:with-param>
   		</xsl:call-template>

    <td align="right" valign="bottom">&nbsp;</td>
    <td align="right" valign="bottom">&nbsp;</td>
  </tr>
  <tr>
    <td class="indent1">8) Variazioni nelle rimanenze di prodotti in corso di lavorazione, etc. (+/-)</td>
		<xsl:call-template name="formatto" >
  	 		<xsl:with-param name="Importo">
   				<xsl:value-of select="Variazioni"/>
   			</xsl:with-param>
   		</xsl:call-template>
    <td align="right" valign="bottom">&nbsp;</td>
    <td align="right" valign="bottom">&nbsp;</td>
  </tr>
  <tr>
    <td class="indent1"><U>TOTALE PROVENTI DELLA GESTIONE (A)</U></td>
    <td align="right" valign="bottom">&nbsp;</td>
		<xsl:call-template name="formatto" >
  	 		<xsl:with-param name="Importo">
   				<xsl:value-of select="Totale"/>
   			</xsl:with-param>
   		</xsl:call-template>

    <td align="right" valign="bottom">&nbsp;</td>
  </tr>
	
	</xsl:template>
	<xsl:template match="Costi">
	<tr>
            <td>
              <b>B)
                <u>COSTI DELLA GESTIONE</u>
              </b>
            </td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">9) Personale</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
  	 				<xsl:value-of select="Personale"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>
            <td align="right" valign="bottom">&nbsp;</td>
            <td align="right" valign="bottom">&nbsp;</td>
          </tr>

          <tr>
            <td class="indent1">10) Acquisto di materie prime e/o beni di consumo</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
  	 				<xsl:value-of select="AcquistoBeni"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">11) Variazioni nelle rimanenze di materie prime e/o beni di consumo (+/-)</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
  	 				<xsl:value-of select="Variazioni"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">12) Prestazioni di servizi</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
  	 				<xsl:value-of select="PrestazioniServizi"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">13) Godimento beni di terzi</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
  	 				<xsl:value-of select="GodimentoBeni"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">14) Trasferimenti</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
  	 				<xsl:value-of select="Trasferimenti"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">15) Imposte e tasse</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
  	 				<xsl:value-of select="Imposte"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">16) Quote di ammortamento d&apos;esercizio</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
  	 				<xsl:value-of select="Ammortamento"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">
              <u>TOTALE COSTI DI GESTIONE (B)</u>
            </td>

            <td align="right" valign="bottom">&nbsp;</td>

			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
  	 				<xsl:value-of select="Totale"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>
		<tr>
            <td>&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

         </tr>

          <tr>
            <td>
              <b>RISULTATO DELLA GESTIONE (A-B)</b>
            </td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
  	 				<xsl:value-of select="//ContoEconomico/RisultatoGestione"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>

          </tr>
	</xsl:template>

	<xsl:template match="ProOneriSpecPar">
          <tr>
            <td>
              <b>C)
                <u>PROVENTI E ONERI DA AZIENDE SPECIALI E PARTECIPATE</u>
              </b>
            </td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">17) Utili</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
  	 				<xsl:value-of select="Utili"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">18) Interessi su capitale di dotazione</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
  	 				<xsl:value-of select="Interessi"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">19) Trasferimenti ad aziende speciali e partecipate</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
  	 				<xsl:value-of select="Trasferimenti"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">
              <u>TOTALE (C)</u>(17+18-19)
            </td>
            <td align="right" valign="bottom">&nbsp;</td>

			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
  	 				<xsl:value-of select="Totale"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td>&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td>
              <b>RISULTATO DELLA GESTIONE OPERATIVA (A-B+/-C)</b>
            </td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="//ContoEconomico/RisultatoGestioneOperativa"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


          </tr>
	</xsl:template>

	<xsl:template match="ProvOneriFin">	
	          <tr>
            <td>
              <b>D)
                <u>PROVENTI ED ONERI FINANZIARI</u>
              </b>
            </td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">20) Interessi attivi</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="InteressiAttivi"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">21) Interessi passivi:</td>
            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent2">- su mutui e prestiti</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="InteressiPassivi/Mutui"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent2">- su obbligazioni</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="InteressiPassivi/Obbligazioni"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent2">- su anticipazioni</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="InteressiPassivi/Anticipazioni"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent2">- per altre cause</td>
			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="InteressiPassivi/Altro"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">
              <u>TOTALE (D)</u>(20-21)
            </td>
            <td align="right" valign="bottom">&nbsp;</td>

			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="Totale"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

          </tr>
	</xsl:template>

	<xsl:template match="ProvOneriStra">		
          <tr>
            <td>
              <b>E)
                <u>PROVENTI ED ONERI STRAORDINARI</u>
              </b>
            </td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent3">Proventi</td>
            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">22) Insussistenze del passivo</td>
   			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="Proventi/Insussistenze"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">23) Sopravvenienze attive</td>
   			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="Proventi/Sopravvenienze"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">24) Plusvalenze patrimoniali</td>
   			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="Proventi/Plusvalenze"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">
              <u>Totale Proventi (e.1)</u>(22+23+24)
            </td>
            <td align="right" valign="bottom">&nbsp;</td>

   			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="Proventi/TotaleProventi"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

          </tr>
          <tr>
            <td>&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent3">Oneri</td>
            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">25) Insussistenze dell&apos;attivo</td>
   			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="Oneri/Insussistenze"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">26) Minusvalenze patrimoniali</td>
   			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="Oneri/Minusvalenze"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">27) Accantonamento per svalutazione crediti</td>
   			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="Oneri/Accantonamento"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">28) Oneri straordinari</td>
   			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="Oneri/OneriStraordinari"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">
              <u>Totale Oneri (e.2)</u>(25+26+27+28)
            </td>
            <td align="right" valign="bottom">&nbsp;</td>

   			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="Oneri/TotaleOneri"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td>&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td class="indent1">
              <u>TOTALE (E)</u>(e.1-e.2)
            </td>
            <td align="right" valign="bottom">&nbsp;</td>

   			<xsl:call-template name="formatto" >
  		 		<xsl:with-param name="Importo">
					<xsl:value-of select="Totale"/>
 	  			</xsl:with-param>
	   		</xsl:call-template>


            <td align="right" valign="bottom">&nbsp;</td>

          </tr>

          <tr>
            <td>&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

            <td align="right" valign="bottom">&nbsp;</td>

          </tr>


	</xsl:template>

	
	<xsl:template name="formatto">
		<xsl:param name="Importo"/>
	<td align="right" valign="bottom">
		<xsl:value-of select="format-number (number(translate($Importo,  ','  , '.' )),'#.###.###.###.###.##0,00', 'european') "/>
	</td>
	</xsl:template>
</xsl:stylesheet>