<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format name="european" decimal-separator=',' grouping-separator='.' />
 <xsl:template match="/">
<html>
<head>
	<title>CONTO DEL BILANCIO PER COMUNI</title>
<style type="text/css">
	td { font-family: tahoma; font-size: 7pt; color: #000000; font-weight: normal;}
	td.intest { font-size: 9pt;}
	table.tabella1 { border-collapse: collapse; border-width: 0}
	td.barra { border-bottom: 2px solid #000000}
	td.barra2 { border-bottom: 2px solid #FFFFFF}
</style>
</head>
<body bgcolor="#FFFFFF" text="#000000">
<table width="640" border="0" cellspacing="0" cellpadding="3">
  <tr> 
    <td align="center" colspan="3" class="intest"> 
	      <p>
		      <b>CONTO DEL BILANCIO<br /></b>
		      <b>PER COMUNI<br /></b>
	      </p>
      </td>
  </tr>
  <tr> 
    <td width="290">ESERCIZIO: <xsl:value-of select="//Copertina/Esercizio"/> </td>
    <td width="466">ENTE: <xsl:value-of select="//Copertina/NomeEnte"/></td>
    <td width="229">SIGLA PROVINCIA: <xsl:value-of select="//Copertina/Provincia"/></td>
  </tr>
  <tr> 
    <td width="290">CODICE ISTAT: <xsl:value-of select="//Copertina/CodiceIstat"/>
</td>
    <td width="466">DELIBERA DI APPROVAZIONE: N°<xsl:value-of select="//Copertina/NumDelibera"/></td>
    <xsl:variable name="abitanti"  select ="//Copertina/NumAbitanti" />
    <td width="229">NUMERO DI ABITANTI: <xsl:value-of select ="format-number ($abitanti, '#.###.###.###.###.##0', 'european') "/>
    </td>
  </tr>
  <tr> 
    <td width="290">PARTITA IVA: <xsl:value-of select="//Copertina/PartitaIVA"/></td>
    <td width="466">DEL: <xsl:value-of select="//Copertina/DataDelibera/Giorno"/>/<xsl:value-of select="//Copertina/DataDelibera/Mese"/>/<xsl:value-of select="//Copertina/DataDelibera/Anno"/></td>
    	
    <xsl:variable name="superficie"  select ="//Copertina/Superficie" />
    <td width="229">
    SUPERFICIE (kmq): <xsl:value-of select ="//Copertina/Superficie"/>
    </td>
  </tr>
</table><br/>
<table width="640" border="0" cellspacing="0" cellpadding="3">
  <tr> 
    <td align="center"><b>QUADRO RIASSUNTIVO DELLA GESTIONE DI COMPETENZA</b></td>
  </tr>
</table>
<table class="tabella1" border="1" cellspacing="0" cellpadding="3" bordercolor="#000000" width="640">
  <tr> 
    <td colspan="3" class="barra2">&nbsp;</td>
    <td align="right" width="288" valign="middle" class="barra2">&nbsp;</td>
  </tr>
  <tr> 
    <td colspan="3" class="barra2"> RISCOSSIONI (+)</td>
    <td align="right" width="288" valign="middle" class="barra2">
     	 <xsl:call-template name="Formatta">
    	 <xsl:with-param name="importo" select="//RisultatoDiGestione/DiffRiscPag/Riscossioni"/>
	 </xsl:call-template>
     </td>
  </tr>
  <tr> 
    <td colspan="3" class="barra2">&nbsp;</td>
    <td align="right" width="288" valign="middle" class="barra2">&nbsp;</td>
  </tr>
  <tr> 
    <td colspan="3" class="barra2"> PAGAMENTI (-)</td>
    <td align="right" width="288" valign="middle" class="barra">
   	 <xsl:call-template name="Formatta">
    	 <xsl:with-param name="importo" select="//RisultatoDiGestione/DiffRiscPag/Pagamenti"/>
	 </xsl:call-template>
    </td>
  </tr>
  <tr> 
    <td colspan="3" class="barra2">&nbsp;</td>
    <td align="right" width="288" valign="middle" class="barra2">&nbsp;</td>
  </tr>
  <tr> 
    <td colspan="3" class="barra2"> DIFFERENZA</td>
    <td align="right" width="288" valign="middle" class="barra2">
   	 <xsl:call-template name="Formatta">
    	 <xsl:with-param name="importo" select="//RisultatoDiGestione/DiffRiscPag/Differenza"/>
	 </xsl:call-template>
    </td>
  </tr>
  <tr> 
    <td colspan="3" class="barra2">&nbsp;</td>
    <td align="right" width="288" valign="middle" class="barra2">&nbsp;</td>
  </tr>
  <tr> 
    <td colspan="3" class="barra2"> RESIDUI ATTIVI (+)</td>
    <td align="right" width="288" valign="middle" class="barra">
        <xsl:call-template name="Formatta">
    	 <xsl:with-param name="importo" select="//RisultatoDiGestione/DiffResidui/ResiduiAttivi"/>
	 </xsl:call-template>
    </td>
  </tr>
  <tr> 
    <td colspan="3" class="barra2">&nbsp;</td>
    <td align="right" width="288" valign="middle" class="barra2">&nbsp;</td>
  </tr>
  <tr> 
    <td colspan="3" class="barra2"> RESIDUI PASSIVI (-)</td>
    <td align="right" width="288" valign="middle" class="barra">
        <xsl:call-template name="Formatta">
    	 <xsl:with-param name="importo" select="//RisultatoDiGestione/DiffResidui/ResiduiPassivi"/>
	 </xsl:call-template>
    </td>
  </tr>
  <tr> 
    <td colspan="3" class="barra2">&nbsp;</td>
    <td align="right" width="288" valign="middle" class="barra2">&nbsp;</td>
  </tr>
  <tr> 
    <td colspan="3" class="barra2"> DIFFERENZA</td>
    <td align="right" width="288" valign="middle" class="barra">
        <xsl:call-template name="Formatta">
    	 <xsl:with-param name="importo" select="//RisultatoDiGestione/DiffResidui/Differenza"/>
	 </xsl:call-template>
    </td>
  </tr>
  <tr> 
    <td colspan="3" class="barra2">&nbsp;</td>
    <td align="right" width="288" valign="middle" class="barra2">&nbsp;</td>
  </tr>
  <tr> 
    <td align="center" colspan="3" class="barra2"> AVANZO (+) O DISAVANZO (-)</td>
    <td align="right" width="288" valign="middle" class="barra2">
        <xsl:call-template name="Formatta">
    	 <xsl:with-param name="importo" select="//RisultatoDiGestione/AvanzoDisavanzo"/>
	 </xsl:call-template> 
    </td>
  </tr>
  <tr> 
    <td colspan="3" class="barra2">&nbsp;</td>
    <td align="right" width="288" valign="middle" class="barra">&nbsp;</td>
  </tr>
  <tr> 
    <td colspan="3" class="barra2">&nbsp;</td>
    <td align="right" width="288" valign="middle" class="barra2">&nbsp;</td>
  </tr>
  <tr> 
    <td valign="middle" rowspan="4" align="center" width="140" class="barra2"> 
      RISULTATO DI GESTIONE</td>
    <td colspan="2" width="200" class="barra2">- FONDI VINCOLATI</td>
    <td align="right" width="288" valign="middle" class="barra2">
    <xsl:call-template name="Formatta">
    	 <xsl:with-param name="importo" select="//ElencoFondi/FondiVincolati"/>
	 </xsl:call-template> 
    </td>
  </tr>
  <tr> 
    <td colspan="2" width="200" class="barra2">- FONDI PER FINANZIAMENTO<br />
      &nbsp; SPESE IN CONTO CAPITALE</td>
    <td align="right" width="288" valign="middle" class="barra2">
    <xsl:call-template name="Formatta">
    	 <xsl:with-param name="importo" select="//ElencoFondi/FondiFinaziamento"/>
	 </xsl:call-template> 
    </td>
  </tr>
  <tr> 
    <td colspan="2" width="200" class="barra2">- FONDI DI AMMORTAMENTO</td>
    <td align="right" width="288" valign="middle" class="barra2">
    <xsl:call-template name="Formatta">
    	 <xsl:with-param name="importo" select="//ElencoFondi/FondiAmmortamento"/>
	 </xsl:call-template> 
    </td>
  </tr>
  <tr> 
    <td colspan="2" width="200" class="barra2">- FONDI NON VINCOLATI</td>
    <td align="right" width="288" valign="middle" class="barra2">
    <xsl:call-template name="Formatta">
    	 <xsl:with-param name="importo" select="//ElencoFondi/FondiNonVincolati"/>
	 </xsl:call-template> 
    </td>
  </tr>
  <tr> 
    <td colspan="3" class="barra2">&nbsp;</td>
    <td align="right" width="288" valign="middle" class="barra">&nbsp;</td>
  </tr>
</table>



</body>
</html>

</xsl:template>


<xsl:template name="Formatta">
	   <xsl:param name="importo" />
	   <xsl:param name="imp1" select="translate($importo,  ','  , '.' ) "/>
	   <xsl:param  name="imp2" select ="number($imp1)" />
	     		<xsl:value-of select ="format-number ($imp2, '#.###.###.###.###.##0,00', 'european') "/>
	     </xsl:template>	
    
</xsl:stylesheet>
