<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
	<xsl:decimal-format name="european" decimal-separator="," grouping-separator="."/>
	<xsl:template match="/">
		<html>
			<head>
				<title>CONTO DEL BILANCIO PER COMUNI</title>
				<style type="text/css">
					td { font-family: tahoma; font-size: 7pt; color: #000000; font-weight: normal;}
					td.intest { font-size: 9pt;}
					table.tabella1 { width: 849px; border-collapse: collapse; border-width: 0}
					td.indent1 {padding-left: 15px}
					td.indent2 {padding-left: 30px}
					td.indent3 {padding-left: 45px}
					td.stampa1 { width: 84px }
				</style>
				<style media="print" type="text/css">
					td { font-family: tahoma; font-size: 5pt; color: #000000; }
					table.tabella1 { width: 729px }
					td.stampa1 { width: 64px }
				</style>
			</head>
			<body bgcolor="#FFFFFF" text="#000000">
				<table width="100%" border="0" cellspacing="0" cellpadding="3">
					<tr>
						<td align="center" colspan="3" class="intest">
							<p>
								<b>CONTO DEL BILANCIO<br/>
								</b>
								<b>PER COMUNI<br/>
								</b>
							</p>
						</td>
					</tr>
					<tr>
						<td width="290">ESERCIZIO: <xsl:value-of select="//Copertina/Esercizio"/>
						</td>
						<td width="466">ENTE: <xsl:value-of select="//Copertina/NomeEnte"/>
						</td>
						<td width="229">SIGLA PROVINCIA: <xsl:value-of select="//Copertina/Provincia"/>
						</td>
					</tr>
					<tr>
						<td width="290">CODICE ISTAT: <xsl:value-of select="//Copertina/CodiceIstat"/>
						</td>
						 <td width="466">DELIBERA DI APPROVAZIONE: N°<xsl:value-of select="//Copertina/NumDelibera"/></td>
    <xsl:variable name="abitanti"  select ="//Copertina/NumAbitanti" />
    <td width="229">NUMERO DI ABITANTI: <xsl:value-of select ="format-number ($abitanti, '#.###.###.###.###.##0', 'european') "/>
    </td>
  </tr>
  <tr> 
    <td width="290">PARTITA IVA: <xsl:value-of select="//Copertina/PartitaIVA"/></td>
    <td width="466">DEL: <xsl:value-of select="//Copertina/DataDelibera/Giorno"/>/<xsl:value-of select="//Copertina/DataDelibera/Mese"/>/<xsl:value-of select="//Copertina/DataDelibera/Anno"/></td>
    	
	<xsl:variable name="superficie" select="//Copertina/Superficie"/>
						<td width="229">
    SUPERFICIE (kmq): <xsl:value-of select="//Copertina/Superficie"/>
						</td>
					</tr>
				</table>
				<br/>
				<table width="100%" border="0" cellspacing="0" cellpadding="3">
					<tr>
						<td align="center">
							<b>GESTIONE DELLE SPESE</b>
						</td>
					</tr>
				</table>
			
<table class="tabella1" border="1" cellspacing="0" cellpadding="2" bordercolor="#000000">
  <tr> 
    <td rowspan="5" width="300" align="center">DESCRIZIONE<br/>
      (con i dati della classificazione: Codice e Numero-Capitolo)</td>
    <td rowspan="3" valign="bottom" align="center" width="25">RS</td>
    <td align="center" rowspan="2" class="stampa1">Residui conservati e Stanziamenti 
      definitivi di bilancio</td>
    <td rowspan="5" align="center" valign="middle" class="stampa1">N° di riferimento 
      allo svolgimento</td>
    <td align="center" class="stampa1">Conto del tesoriere</td>
    <td align="center" class="stampa1">Determinazione dei residui</td>
    <td rowspan="2" align="center" valign="middle" class="stampa1">Impegni</td>
    <td rowspan="2" align="center" class="stampa1">Minori residui o economie</td>
  </tr>
  <tr> 
    <td align="center" class="stampa1">Pagamenti</td>
    <td align="center" class="stampa1">Residui da riportare</td>
  </tr>
  <tr> 
    <td align="center" class="stampa1">Residui (A)</td>
    <td align="center" class="stampa1">Residui (B)</td>
    <td align="center" class="stampa1">Residui (C=D-B)</td>
    <td class="stampa1" align="center" valign="middle">Residui (D)</td>
    <td align="center" class="stampa1">(E=A-D)(*)</td>
  </tr>
  <tr> 
    <td width="25" align="center">CP</td>
    <td align="center" class="stampa1">Competenza (F)</td>
    <td align="center" class="stampa1">Competenza (G)</td>
    <td align="center" class="stampa1">Competenza (H)</td>
    <td align="center" class="stampa1">Competenza (I=G+H) (**)</td>
    <td align="center" rowspan="2" class="stampa1">(L=F-I) </td>
  </tr>
  <tr> 
    <td width="25" align="center">T</td>
    <td align="center" class="stampa1">Totale (M)</td>
    <td align="center" class="stampa1">Totale (N)</td>
    <td align="center" class="stampa1">Residui al 31 dicembre (O=C+H)</td>
    <td align="center" class="stampa1">Impegni al 31 dicembre (P=D+I)</td>
  </tr>
  
 <xsl:call-template name="FormattaTitolo">
			<xsl:with-param name="Titolo" 	select=" 'TITOLO I - SPESE CORRENTI ' "/>
</xsl:call-template>
                       
<xsl:call-template name="FormattaFunzione1TitoloI">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloI/FUNZIONE1"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 1 - FUNZIONI GENERALI DI AMMINISTRAZIONE, DI GESTIONE E DI CONTROLLO' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 1 ' "/> 	
	<xsl:with-param name="NumFunzione" select=" '01' "/> 			
</xsl:call-template>

<xsl:call-template name="FormattaFunzione2TitoloI">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloI/FUNZIONE2"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 2 - FUNZIONI RELATIVE ALLA GIUSTIZIA' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 2 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '02' "/> 
</xsl:call-template>

<xsl:call-template name="FormattaFunzione3TitoloI">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloI/FUNZIONE3"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 3 - FUNZIONI DI POLIZIA LOCALE' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 3 ' "/> 	
		<xsl:with-param name="NumFunzione" select=" '03' "/> 
			
</xsl:call-template>

<xsl:call-template name="FormattaFunzione4TitoloI">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloI/FUNZIONE4"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 4 - FUNZIONI DI ISTRUZIONE PUBBLICA' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 4 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '04' "/> 
</xsl:call-template>

<xsl:call-template name="FormattaFunzione5TitoloI">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloI/FUNZIONE5"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 5 - FUNZIONI RELATIVE ALLA CULTURA ED AI BENI CULTURALI' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 5 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '05' "/> 
</xsl:call-template>

<xsl:call-template name="FormattaFunzione6TitoloI">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloI/FUNZIONE6"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 6 - FUNZIONI NEL SETTORE SPORTIVO E RICREATIVO' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 6 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '06' "/> 
</xsl:call-template>

<xsl:call-template name="FormattaFunzione7TitoloI">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloI/FUNZIONE7"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 7 - FUNZIONI NEL CAMPO TURISTICO' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 7 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '07' "/> 
</xsl:call-template>

<xsl:call-template name="FormattaFunzione8TitoloI">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloI/FUNZIONE8"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 8 - FUNZIONI NEL CAMPO DELLA VIABILITÁ E DEI TRASPORTI' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 8 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '08' "/> 
</xsl:call-template>

<xsl:call-template name="FormattaFunzione9TitoloI">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloI/FUNZIONE9"/>
	<xsl:with-param name="NomeFunzione" select="  'FUNZIONE 9 - FUNZIONI RIGUARDANTI LA GESTIONE DEL TERRITORIO E DELL´AMBIENTE' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 9 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '09' "/> 
</xsl:call-template>

<xsl:call-template name="FormattaFunzione10TitoloI">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloI/FUNZIONE10"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 10 - FUNZIONI NEL SETTORE SOCIALE' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 10 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '10' "/> 
</xsl:call-template>
<xsl:call-template name="FormattaFunzione11TitoloI">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloI/FUNZIONE11"/>
	<xsl:with-param name="NomeFunzione" select="  'FUNZIONE 11 - FUNZIONI NEL CAMPO DELLO SVILUPPO ECONOMICO' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 11 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '11' "/> 
</xsl:call-template>
<xsl:call-template name="FormattaFunzione12TitoloI">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloI/FUNZIONE12"/>
	<xsl:with-param name="NomeFunzione" select="  'FUNZIONE 12 - FUNZIONI RELATIVE A SERVIZI PRODUTTIVI' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 12 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '12' "/> 
</xsl:call-template>

<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select=" 'TOTALE TITOLO I' "/>
	<xsl:with-param name="Totale" select="//GestioneSpesa/TotaleGenerale/TitoloI/TotaleTitoloI"/>
</xsl:call-template>

 <xsl:call-template name="FormattaTitolo">
			<xsl:with-param name="Titolo" 	select=" 'TITOLO II - SPESE IN CONTO CAPITALE' "/>
</xsl:call-template>                      
   
   
   <xsl:call-template name="FormattaFunzione1TitoloII">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloII/FUNZIONE1"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 1 - FUNZIONI GENERALI DI AMMINISTRAZIONE, DI GESTIONE E DI CONTROLLO' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 1 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '01' "/> 
</xsl:call-template>

<xsl:call-template name="FormattaFunzione2TitoloII">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloII/FUNZIONE2"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 2 - FUNZIONI RELATIVE ALLA GIUSTIZIA' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 2 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '02' "/> 
</xsl:call-template>

<xsl:call-template name="FormattaFunzione3TitoloII">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloII/FUNZIONE3"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 3 - FUNZIONI DI POLIZIA LOCALE' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 3 ' "/> 	
		<xsl:with-param name="NumFunzione" select=" '03' "/> 
			
</xsl:call-template>

<xsl:call-template name="FormattaFunzione4TitoloII">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloII/FUNZIONE4"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 4 - FUNZIONI DI ISTRUZIONE PUBBLICA' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 4 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '04' "/> 
</xsl:call-template>

<xsl:call-template name="FormattaFunzione5TitoloII">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloII/FUNZIONE5"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 5 - FUNZIONI RELATIVE ALLA CULTURA ED AI BENI CULTURALI' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 5 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '05' "/> 
</xsl:call-template>

<xsl:call-template name="FormattaFunzione6TitoloII">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloII/FUNZIONE6"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 6 - FUNZIONI NEL SETTORE SPORTIVO E RICREATIVO' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 6 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '06' "/> 
</xsl:call-template>

<xsl:call-template name="FormattaFunzione7TitoloII">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloII/FUNZIONE7"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 7 - FUNZIONI NEL CAMPO TURISTICO' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 7 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '07' "/> 
</xsl:call-template>

<xsl:call-template name="FormattaFunzione8TitoloII">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloII/FUNZIONE8"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 8 - FUNZIONI NEL CAMPO DELLA VIABILITÁ E DEI TRASPORTI' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 8 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '08' "/> 
</xsl:call-template>

<xsl:call-template name="FormattaFunzione9TitoloII">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloII/FUNZIONE9"/>
	<xsl:with-param name="NomeFunzione" select="  'FUNZIONE 9 - FUNZIONI RIGUARDANTI LA GESTIONE DEL TERRITORIO E DELL´AMBIENTE' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 9 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '09' "/> 
</xsl:call-template>

<xsl:call-template name="FormattaFunzione10TitoloII">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloII/FUNZIONE10"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 10 - FUNZIONI NEL SETTORE SOCIALE' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 10 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '10' "/> 
</xsl:call-template>
<xsl:call-template name="FormattaFunzione11TitoloII">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloII/FUNZIONE11"/>
	<xsl:with-param name="NomeFunzione" select="  'FUNZIONE 11 - FUNZIONI NEL CAMPO DELLO SVILUPPO ECONOMICO' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 11 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '11' "/> 
</xsl:call-template>
<xsl:call-template name="FormattaFunzione12TitoloII">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloII/FUNZIONE12"/>
	<xsl:with-param name="NomeFunzione" select="  'FUNZIONE 12 - FUNZIONI RELATIVE A SERVIZI PRODUTTIVI' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 12 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '12' "/> 
</xsl:call-template>



<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select=" 'TOTALE TITOLO II' "/>
	<xsl:with-param name="Totale" select="//GestioneSpesa/TotaleGenerale/TitoloII/TotaleTitoloII"/>
</xsl:call-template>
                       
 <xsl:call-template name="FormattaTitolo">
			<xsl:with-param name="Titolo" 	select=" 'TITOLO III - SPESE PER RIMBORSO DI PRESTITI' "/>
</xsl:call-template>
 <xsl:call-template name="FormattaFunzione1TitoloIII">
	 <xsl:with-param name="Funzione" select="//GestioneSpesa/TotaleGenerale/TitoloIII/FUNZIONE1"/>
	<xsl:with-param name="NomeFunzione" select=" 'FUNZIONE 1 - FUNZIONI GENERALI DI AMMINISTRAZIONE, DI GESTIONE E DI CONTROLLO' "/>
	<xsl:with-param name="TotaleFunzione" select=" 'TOTALE FUNZIONE 1 ' "/> 			
		<xsl:with-param name="NumFunzione" select=" '01' "/> 
</xsl:call-template>

<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select=" 'TOTALE TITOLO III' "/>
	<xsl:with-param name="Totale" select="//GestioneSpesa/TotaleGenerale/TitoloIII/TotaleTitoloIII"/>
</xsl:call-template>

 <xsl:call-template name="FormattaTitolo">
			<xsl:with-param name="Titolo" 	select=" 'TITOLO IV - SPESE PER SERVIZI PER CONTO DI TERZI' "/>
</xsl:call-template>
  
 <xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" '4000001 - RITENUTE PREVIDENZIALI ED ASSISTENZIALI AL PERSONALE' "/>
	<xsl:with-param name="Intervento" select="//GestioneSpesa/TotaleGenerale/TitoloIV/RITENUTE_PREVIDENZIALI"/>
  </xsl:call-template>

 <xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" '4000002 - RITENUTE ERARIALI' "/>
	<xsl:with-param name="Intervento" select="//GestioneSpesa/TotaleGenerale/TitoloIV/RITENUTE_ERARIALI"/>
  </xsl:call-template>

<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" '4000003 - ALTRE RITENUTE AL PERSONALE PER CONTO DI TERZI' "/>
	<xsl:with-param name="Intervento" select="//GestioneSpesa/TotaleGenerale/TitoloIV/ALTRE_RITENUTE"/>
  </xsl:call-template>

<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" '4000004 - RESTITUZIONE DI DEPOSITI CAUZIONALI ' "/>
	<xsl:with-param name="Intervento" select="//GestioneSpesa/TotaleGenerale/TitoloIV/RESTITUZIONE_DEPOSITI_CAU"/>
  </xsl:call-template>

<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" '4000005 - SPESE PER SERVIZI PER CONTO DI TERZI' "/>
	<xsl:with-param name="Intervento" select="//GestioneSpesa/TotaleGenerale/TitoloIV/SPESE_SERVIZI"/>
  </xsl:call-template>

<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" '4000006 - ANTICIPAZIONE DI FONDI PER IL SERVIZIO ECONOMATO' "/>
	<xsl:with-param name="Intervento" select="//GestioneSpesa/TotaleGenerale/TitoloIV/ANTICIPAZIONE_FONDI"/>
  </xsl:call-template>

<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" '4000007 - RESTITUZIONE DI DEPOSITI PER SPESE CONTRATTUALI' "/>
	<xsl:with-param name="Intervento" select="//GestioneSpesa/TotaleGenerale/TitoloIV/RESTITUZIONE_DEPOSITI"/>
  </xsl:call-template>  
   
   
  <xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select=" 'TOTALE TITOLO IV' "/>
	<xsl:with-param name="Totale" select="//GestioneSpesa/TotaleGenerale/TitoloIV/TotaleTitoloIV"/>
</xsl:call-template>


<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select=" 'TOTALE GENERALE' "/>
	<xsl:with-param name="Totale" select="//GestioneSpesa/TotaleGenerale/Totale"/>
</xsl:call-template>

<tr valign="bottom">
	<td align="right">
	DISAVANZO DI AMMINISTRAZIONE
	</td>
	<td align="center">&nbsp;</td>
	<td align="right"> <xsl:value-of select="//GestioneSpesa/Disavanzo"/></td>
	<td align="center">&nbsp;</td>
	<td align="center">&nbsp;</td>
	<td align="center">&nbsp;</td>
	<td align="center">&nbsp;</td>
	<td align="center">&nbsp;</td>
</tr>
<tr>
	<td align="center">&nbsp;</td>
	<td align="center">&nbsp;</td>
	<td align="center">&nbsp;</td>
	<td align="center">&nbsp;</td>
	<td align="center">&nbsp;</td>
	<td align="center">&nbsp;</td>
	<td align="center">&nbsp;</td>
	<td align="center">&nbsp;</td>
</tr>
<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select=" 'TOTALE GENERALE DELLE SPESE' "/>
	<xsl:with-param name="Totale" select="//GestioneSpesa/TotaleGeneraleSpesa"/>
</xsl:call-template>

</table>
<table width="100%" border="0" cellspacing="0" cellpadding="3">
  <tr> 
    <td>(*) Motivi del verificarsi dei minori residui attivi: Insussistenti (INS); 
      Prescritti (PRE)<br/>
      (**) Indicare la parte degli impegni che si riferisce a mere regolazioni 
      contabili di spese correlate alle entrate </td>
  </tr>
</table>
<p>&nbsp;</p>
</body>
</html>
					
</xsl:template>



<!-- ****************************************************************************** -->
<!-- ScriviTotale   : Scrive la riga dei Totali a livello di Totale -->
<!-- ****************************************************************************** -->

<xsl:template name="ScriviTotale">


<xsl:param name="NomeTotale"/>
<xsl:param name="Totale"/>


<xsl:param name="ResiduiConservatiRS_Virgola" select="$Totale/ResiduiConservatiRS"/>
<xsl:param name="ResiduiConservatiRS_Punto" select="translate($ResiduiConservatiRS_Virgola,  ','  , '.' ) "/>
<xsl:param name="ResiduiConservatiRS" select="number($ResiduiConservatiRS_Punto)"/>
<xsl:param name="ResiduiConservatiCP_Virgola" select="$Totale/ResiduiConservatiCP"/>
<xsl:param name="ResiduiConservatiCP_Punto" select="translate($ResiduiConservatiCP_Virgola,  ','  , '.' ) "/>
<xsl:param name="ResiduiConservatiCP" select="number($ResiduiConservatiCP_Punto)"/>
<xsl:param name="ResiduiConservatiT_Virgola" select="$Totale/ResiduiConservatiT"/>
<xsl:param name="ResiduiConservatiT_Punto" select="translate($ResiduiConservatiT_Virgola,  ','  , '.' ) "/>
<xsl:param name="ResiduiConservatiT" select="number($ResiduiConservatiT_Punto)"/>


<xsl:param name="PagamentiRS_Virgola" select="$Totale/PagamentiRS"/>
<xsl:param name="PagamentiRS_Punto" select="translate($PagamentiRS_Virgola,  ','  , '.' ) "/>
<xsl:param name="PagamentiRS" select="number($PagamentiRS_Punto)"/>

<xsl:param name="PagamentiCP_Virgola" select="$Totale/PagamentiCP"/>
<xsl:param name="PagamentiCP_Punto" select="translate($PagamentiCP_Virgola,  ','  , '.' ) "/>
<xsl:param name="PagamentiCP" select="number($PagamentiCP_Punto)"/>

<xsl:param name="Cor_Virgola" select="$Totale/Cor"/>
<xsl:param name="Cor_Punto" select="translate($Cor_Virgola,  ','  , '.' ) "/>
<xsl:param name="Cor" select="number($Cor_Punto)"/>


<xsl:param name="PagamentiT_Virgola" select="$Totale/PagamentiT"/>
<xsl:param name="PagamentiT_Punto" select="translate($PagamentiT_Virgola,  ','  , '.' ) "/>
<xsl:param name="PagamentiT" select="number($PagamentiT_Punto)"/>


<xsl:param name="ResiduiDaRiportareRS_Virgola" select="$Totale/ ResiduiDaRiportareRS"/>
<xsl:param name="ResiduiDaRiportareRS_Punto" select="translate($ResiduiDaRiportareRS_Virgola,  ','  , '.' ) "/>
<xsl:param name="ResiduiDaRiportareRS" select="number($ResiduiDaRiportareRS_Punto)"/>
<xsl:param name="ResiduiDaRiportareCP_Virgola" select="$Totale/  ResiduiDaRiportareCP"/>
<xsl:param name="ResiduiDaRiportareCP_Punto" select="translate($ResiduiDaRiportareCP_Virgola,  ','  , '.' ) "/>
<xsl:param name="ResiduiDaRiportareCP" select="number($ResiduiDaRiportareCP_Punto)"/>
<xsl:param name="ResiduiDaRiportareT_Virgola" select="$Totale/  ResiduiDaRiportareT"/>
<xsl:param name="ResiduiDaRiportareT_Punto" select="translate($ResiduiDaRiportareT_Virgola,  ','  , '.' ) "/>
<xsl:param name="ResiduiDaRiportareT" select="number($ResiduiDaRiportareT_Punto)"/>

<xsl:param name="ImpegniRS_Virgola" select="$Totale/  ImpegniRS"/>
<xsl:param name="ImpegniRS_Punto" select="translate($ImpegniRS_Virgola,  ','  , '.' ) "/>
<xsl:param name="ImpegniRS" select="number($ImpegniRS_Punto)"/>
<xsl:param name="ImpegniCP_Virgola" select="$Totale/  ImpegniCP"/>
<xsl:param name="ImpegniCP_Punto" select="translate($ImpegniCP_Virgola,  ','  , '.' ) "/>
<xsl:param name="ImpegniCP" select="number($ImpegniCP_Punto)"/>
<xsl:param name="ImpegniT_Virgola" select="$Totale/  ImpegniT"/>
<xsl:param name="ImpegniT_Punto" select="translate($ImpegniT_Virgola,  ','  , '.' ) "/>
<xsl:param name="ImpegniT" select="number($ImpegniT_Punto)"/>

<xsl:param name="RS_Virgola" select="$Totale/  MinResRS"/>
<xsl:param name="RS_Punto" select="translate($RS_Virgola,  ','  , '.' ) "/>
<xsl:param name="RS" select="number($RS_Punto)"/>

<xsl:param name="CP_Virgola" select="$Totale/  MinResCP"/>
<xsl:param name="CP_Punto" select="translate($CP_Virgola,  ','  , '.' ) "/>
<xsl:param name="CP" select="number($CP_Punto)"/>

<xsl:if test="$Totale" >
		
<tr valign="bottom"> 
    <td align="right"><b><xsl:value-of select="$NomeTotale"/></b></td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
     </tr>
			
<tr>
	<td align="center"></td>
	<td align="right">RS</td>
	<td align="right"><xsl:value-of select="format-number ($ResiduiConservatiRS,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="translate(format-number ($Totale/NRif,'#.###.###.###.###.##0', 'european'),'NaN' , '')"/></td>
	<td align="right"><xsl:value-of select="format-number ($PagamentiRS,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="format-number ($ResiduiDaRiportareRS,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="format-number ($ImpegniRS,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="format-number ($RS,'#.###.###.###.###.##0,00', 'european')"/></td>
</tr>		
<tr valign="bottom">
	<td>&nbsp;</td>
	<td align="right">CP</td>
	<td align="right"><xsl:value-of select="format-number ($ResiduiConservatiCP,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right">&nbsp;</td>
	<td align="right"><xsl:value-of select="format-number ($PagamentiCP,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="format-number ($ResiduiDaRiportareCP,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="format-number ($ImpegniCP,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="format-number ($CP,'#.###.###.###.###.##0,00', 'european')"/></td>
	
</tr>
						
<tr valign="bottom">
	<td>&nbsp;</td>
	<td align="right">T.</td>
	<td align="right"><xsl:value-of select="format-number ($ResiduiConservatiT,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right">&nbsp;</td>
	<td align="right"><xsl:value-of select="format-number ($PagamentiT,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="format-number ($ResiduiDaRiportareT,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="format-number ($ImpegniT,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right">&nbsp;</td>
		
</tr>

	 <xsl:call-template name="RigaBianca" />


</xsl:if>
</xsl:template>

<!--FINE    ScriviTotale   : Scrive la riga dei Totali a livello di Servizio  -->



<!-- **************************************************************************************************-->
<!-- ScriviIntervento     Scrive le righe degli importi  corrispondenti ad ogni Intrevento  
					 Scrive la descrizione dell'intervento opportunamente indentata
					 Input : Intervento = Nome nodo intervento
					 	     NomeIntervento =  Descrizione dell'intervento da visualizzare-->
					 	     
<!-- **************************************************************************************************-->
					 	     
<xsl:template name="ScriviIntervento">


<xsl:param name="Intervento"/>
<xsl:param name="NomeIntervento"/>




<xsl:param name="ResiduiConservatiRS_Virgola" select="$Intervento/ResiduiConservatiRS"/>
<xsl:param name="ResiduiConservatiRS_Punto" select="translate($ResiduiConservatiRS_Virgola,  ','  , '.' ) "/>
<xsl:param name="ResiduiConservatiRS" select="number($ResiduiConservatiRS_Punto)"/>
<xsl:param name="ResiduiConservatiCP_Virgola" select="$Intervento/ResiduiConservatiCP"/>
<xsl:param name="ResiduiConservatiCP_Punto" select="translate($ResiduiConservatiCP_Virgola,  ','  , '.' ) "/>
<xsl:param name="ResiduiConservatiCP" select="number($ResiduiConservatiCP_Punto)"/>
<xsl:param name="ResiduiConservatiT_Virgola" select="$Intervento/ResiduiConservatiT"/>
<xsl:param name="ResiduiConservatiT_Punto" select="translate($ResiduiConservatiT_Virgola,  ','  , '.' ) "/>
<xsl:param name="ResiduiConservatiT" select="number($ResiduiConservatiT_Punto)"/>
		


<xsl:param name="PagamentiRS_Virgola" select="$Intervento/PagamentiRS"/>
<xsl:param name="PagamentiRS_Punto" select="translate($PagamentiRS_Virgola,  ','  , '.' ) "/>
<xsl:param name="PagamentiRS" select="number($PagamentiRS_Punto)"/>

<xsl:param name="PagamentiCP_Virgola" select="$Intervento/PagamentiCP"/>
<xsl:param name="PagamentiCP_Punto" select="translate($PagamentiCP_Virgola,  ','  , '.' ) "/>
<xsl:param name="PagamentiCP" select="number($PagamentiCP_Punto)"/>

<xsl:param name="PagamentiT_Virgola" select="$Intervento/PagamentiT"/>
<xsl:param name="PagamentiT_Punto" select="translate($PagamentiT_Virgola,  ','  , '.' ) "/>
<xsl:param name="PagamentiT" select="number($PagamentiT_Punto)"/>


<xsl:param name="ResiduiDaRiportareRS_Virgola" select="$Intervento/ResiduiDaRiportareRS"/>
<xsl:param name="ResiduiDaRiportareRS_Punto" select="translate($ResiduiDaRiportareRS_Virgola,  ','  , '.' ) "/>
<xsl:param name="ResiduiDaRiportareRS" select="number($ResiduiDaRiportareRS_Punto)"/>
<xsl:param name="ResiduiDaRiportareCP_Virgola" select="$Intervento/ResiduiDaRiportareCP"/>
<xsl:param name="ResiduiDaRiportareCP_Punto" select="translate($ResiduiDaRiportareCP_Virgola,  ','  , '.' ) "/>
<xsl:param name="ResiduiDaRiportareCP" select="number($ResiduiDaRiportareCP_Punto)"/>
<xsl:param name="ResiduiDaRiportareT_Virgola" select="$Intervento/ResiduiDaRiportareT"/>
<xsl:param name="ResiduiDaRiportareT_Punto" select="translate($ResiduiDaRiportareT_Virgola,  ','  , '.' ) "/>
<xsl:param name="ResiduiDaRiportareT" select="number($ResiduiDaRiportareT_Punto)"/>

<xsl:param name="ImpegniRS_Virgola" select="$Intervento/ImpegniRS"/>
<xsl:param name="ImpegniRS_Punto" select="translate($ImpegniRS_Virgola,  ','  , '.' ) "/>
<xsl:param name="ImpegniRS" select="number($ImpegniRS_Punto)"/>
<xsl:param name="ImpegniCP_Virgola" select="$Intervento/ImpegniCP"/>
<xsl:param name="ImpegniCP_Punto" select="translate($ImpegniCP_Virgola,  ','  , '.' ) "/>
<xsl:param name="ImpegniCP" select="number($ImpegniCP_Punto)"/>
<xsl:param name="ImpegniT_Virgola" select="$Intervento/ImpegniT"/>
<xsl:param name="ImpegniT_Punto" select="translate($ImpegniT_Virgola,  ','  , '.' ) "/>
<xsl:param name="ImpegniT" select="number($ImpegniT_Punto)"/>

<xsl:param name="RS_Virgola" select="$Intervento/MinResRS"/>
<xsl:param name="RS_Punto" select="translate($RS_Virgola,  ','  , '.' ) "/>
<xsl:param name="RS" select="number($RS_Punto)"/>

<xsl:param name="CP_Virgola" select="$Intervento/MinResCP"/>
<xsl:param name="CP_Punto" select="translate($CP_Virgola,  ','  , '.' ) "/>
<xsl:param name="CP" select="number($CP_Punto)"/>

<xsl:if test="$Intervento" >
		
<tr valign="bottom">
	<td class="indent3"> <xsl:value-of select="$NomeIntervento"/></td>
	<td align="right">&nbsp;</td>
	<td align="right">&nbsp;</td>
	<td align="right">&nbsp;</td>
	<td align="right">&nbsp;</td>
	<td align="right">&nbsp;</td>
	<td align="right">&nbsp;</td>
	<td align="right">&nbsp;</td>
</tr>
			
<tr>
	<td align="center"></td>
	<td align="right">RS</td>
	<td align="right"><xsl:value-of select="format-number ($ResiduiConservatiRS,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="translate(format-number ($Intervento/NRif,'#.###.###.###.###.##0', 'european'),'NaN' , '')"/></td>
	<td align="right"><xsl:value-of select="format-number ($PagamentiRS,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="format-number ($ResiduiDaRiportareRS,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="format-number ($ImpegniRS,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="format-number ($RS,'#.###.###.###.###.##0,00', 'european')"/></td>
</tr>		
<tr valign="bottom">
	<td>&nbsp;</td>
	<td align="right">CP</td>
	<td align="right"><xsl:value-of select="format-number ($ResiduiConservatiCP,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right">&nbsp;</td>
	<td align="right"><xsl:value-of select="format-number ($PagamentiCP,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="format-number ($ResiduiDaRiportareCP,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="format-number ($ImpegniCP,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="format-number ($CP,'#.###.###.###.###.##0,00', 'european')"/></td>

</tr>
			
			
<tr valign="bottom">
	<td>&nbsp;</td>
	<td align="right">T.</td>
	<td align="right">
		<xsl:value-of select="format-number ($ResiduiConservatiT,'#.###.###.###.###.##0,00', 'european')"/>
	</td>
	<td align="right">&nbsp;</td>
	<td align="right"><xsl:value-of select="format-number ($PagamentiT,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="format-number ($ResiduiDaRiportareT,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right"><xsl:value-of select="format-number ($ImpegniT,'#.###.###.###.###.##0,00', 'european')"/></td>
	<td align="right">&nbsp;</td>
	
</tr>
	
	



</xsl:if>
</xsl:template>
<!-- FINE   ScriviIntervento     	-->

	



<xsl:template name="FormattaTitolo" >
	  <xsl:param name="Titolo" />
	   
  <tr valign="bottom"> 
  <td><xsl:value-of select="$Titolo"/></td>
  <td align="center">&nbsp;</td>
  <td align="right">&nbsp;</td>
  <td align="right">&nbsp;</td>
  <td align="right">&nbsp;</td>
  <td align="right">&nbsp;</td>
  <td align="right">&nbsp;</td>
  <td align="right">&nbsp;</td>
  
</tr>
 </xsl:template>

<xsl:template name="FormattaFunzione" >
	  <xsl:param name="Funzione" />
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$Funzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>

  </tr>

 </xsl:template>
 
 <xsl:template name="FormattaServizio" >
	  <xsl:param name="Servizio" />
  <tr valign="bottom">
	  <td class="indent2"> <xsl:value-of select="$Servizio"/> </td>
  
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>

  </tr> 
  </xsl:template>
  
  
  
  

 
 <!--- FORMATTA SERVIZIO TITOLO I  inizio -->
  <xsl:template name="FormattaServizioTitoloI" >
   <xsl:param name="Servizio" />
   <xsl:param name="NomeServizio" />
   <xsl:param name="TotaleServizio" />
   <xsl:param name="NumFunzione1" />
   <xsl:param name="NumServizio" />

  <tr valign="bottom">
	  <td class="indent2"> <xsl:value-of select="$NomeServizio"/> </td>
  
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
   
  </tr> 

  <xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('1' , $NumFunzione1 , $NumServizio , '01 - PERSONALE') "/>
	<xsl:with-param name="Intervento" select="$Servizio/PERSONALE"/>
	
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('1' , $NumFunzione1 , $NumServizio , '02 - ACQUISTO DI BENI DI CONSUMO E/O DI MATERIE PRIME') "/>
	<xsl:with-param name="Intervento" select="$Servizio/ACQUISTO_BENI_CONSUMO"/>
</xsl:call-template>

<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('1' , $NumFunzione1 , $NumServizio , '03 - PRESTAZIONI DI SERVIZI') "/>
	<xsl:with-param name="Intervento" select="$Servizio/PRESTAZIONI_SERVIZI"/>
</xsl:call-template>

<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('1' , $NumFunzione1 , $NumServizio , '04 - UTILIZZO DI BENI DI TERZI') "/>
	<xsl:with-param name="Intervento" select="$Servizio/UTILIZZO_BENI_TERZI"/>
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('1' , $NumFunzione1 , $NumServizio , '05 - TRASFERIMENTI') "/>
	<xsl:with-param name="Intervento" select="$Servizio/TRASFERIMENTI"/>
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('1' , $NumFunzione1 , $NumServizio , '06 - INTERESSI PASSIVI E ONERI FINANZIARI DIVERSI') "/>
	<xsl:with-param name="Intervento" select="$Servizio/INTERESSI_PASSIVI"/>
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('1' , $NumFunzione1 , $NumServizio , '07 - IMPOSTE E TASSE') "/>
	<xsl:with-param name="Intervento" select="$Servizio/IMPOSTE_TASSE"/>
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('1' , $NumFunzione1 , $NumServizio , '08 - ONERI STRAORDINARI DELLA GESTIONE CORRENTE ') "/>
	<xsl:with-param name="Intervento" select="$Servizio/ONERI_STRAORDINARI"/>
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('1' , $NumFunzione1 , $NumServizio , '09 - AMMORTAMENTI DI ESERCIZIO') "/>
	<xsl:with-param name="Intervento" select="$Servizio/AMMORTAMENTI_ESERCIZIO"/>
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('1' , $NumFunzione1 , $NumServizio , '10 - FONDO SVALUTAZIONE CREDITI') "/>
	<xsl:with-param name="Intervento" select="$Servizio/FONDO_SVALUTAZIONE_CREDITI"/>
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('1' , $NumFunzione1 , $NumServizio , '11 - FONDO DI RISERVA') "/>
	<xsl:with-param name="Intervento" select="$Servizio/FONDO_RISERVA"/>
</xsl:call-template>
<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleServizio"/>
	<xsl:with-param name="Totale" select="$Servizio/Totale"/>
</xsl:call-template>
</xsl:template>

   <!--- FORMATTA SERVIZIO TITOLO I FINE -->
 
 <!--  FORMATTAZIONE FUNZIONE1 TITOLOI   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione1TitoloI" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
  
  
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
  <xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>

			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - ORGANI ISTITUZIONALI, PARTECIPAZIONE E DECENTRAMENTO' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>			

</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - SEGRETERIA GENERALE, PERSONALE E ORGANIZZAZIONE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>			

</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - GESTIONE ECONOMICA, FINANZIARIA, PROGRAMMAZIONE, PROVVEDITORATO E CONTROLLO DI GESTIONE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '03' "/>			

</xsl:call-template>
	<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO4"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 4 - GESTIONE DELLE ENTRATE TRIBUTARIE E SERVIZI FISCALI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 4 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '04' "/>			

	</xsl:call-template>
	<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO5"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 5 - GESTIONE DEI BENI DEMANIALI E PATRIMONIALI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 5 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '05' "/>			

	</xsl:call-template>
	<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO6"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 6 - UFFICIO TECNICO' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 6 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '06' "/>			

	</xsl:call-template>
	<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO7"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 7 - ANAGRAFE, STATO CIVILE, ELETTORALE, LEVA E SERVIZIO STATISTICO' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 7 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '07' "/>			

	</xsl:call-template>
	<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO8"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 8 - ALTRI SERVIZI GENERALI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 8 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '08' "/>			

	</xsl:call-template>

				
<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione1"/>
</xsl:call-template>
			
			


  </xsl:template>
  
  
  
  
  
   <!--  FORMATTAZIONE FUNZIONE2 TITOLOI   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione2TitoloI" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />      
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
     </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloI">
		<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
		<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - UFFICI GIUDIZIARI' "/>
		<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
		<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
		<xsl:with-param name="NumServizio" select=" '01' "/>		

</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
		<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
		<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - CASA CIRCONDARIALE E ALTRI SERVIZI' "/>
		<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
		<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
		<xsl:with-param name="NumServizio" select=" '02' "/>		

</xsl:call-template>
			
<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione2"/>
</xsl:call-template>
	

  </xsl:template>
 
<!-- FINE   FORMATTAZIONE FUNZIONE2 TITOLOI --> 


<!--  FORMATTAZIONE FUNZIONE 3 TITOLOI   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione3TitoloI" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
      
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
     </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - POLIZIA MUNICIPALE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>
			

</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - POLIZIA COMMERCIALE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>
			

</xsl:call-template>

<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - POLIZIA AMMINISTRATIVA' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '03' "/>
			

</xsl:call-template>

	<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione3"/>
</xsl:call-template>
	

  </xsl:template>
 
<!-- FINE   FORMATTAZIONE FUNZIONE3 TITOLOI --> 


<!--  FORMATTAZIONE FUNZIONE 4 TITOLOI   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione4TitoloI" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />   
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - SCUOLA MATERNA' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>			

</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - ISTRUZIONE ELEMENTARE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>			
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - ISTRUZIONE MEDIA' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '03' "/>			
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO4"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 4 - ISTRUZIONE SECONDARIA SUPERIORE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 4 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '04' "/>			

</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO5"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 5 - ASSISTENZA SCOLASTICA, TRASPORTO, REFEZIONE E ALTRI SERVIZI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 5' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '05' "/>			

</xsl:call-template>


	<xsl:call-template name="ScriviTotale">
		<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
		<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione4"/>
	</xsl:call-template>
	

	

  </xsl:template>
 
<!-- FINE   FORMATTAZIONE FUNZIONE4 TITOLOI --> 


<!--  FORMATTAZIONE FUNZIONE 5TITOLOI   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione5TitoloI" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />   
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - BIBLIOTECHE, MUSEI E PINACOTECHE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>			

</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - TEATRI, ATTIVITA´ CULTURALI E SERVIZI DIVERSI NEL SETTORE CULTURALE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>			

</xsl:call-template>

	
	<xsl:call-template name="ScriviTotale">
		<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
		<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione5"/>
	</xsl:call-template>
	

  </xsl:template>
 
<!-- FINE   FORMATTAZIONE FUNZIONE 5TITOLOI --> 

<!--  FORMATTAZIONE FUNZIONE 6TITOLOI   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione6TitoloI" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloI">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - PISCINE COMUNALI' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '01' "/>			
	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - STADIO COMUNALE, PALAZZO DELLO SPORT ED ALTRI IMPIANTI' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '02' "/>	
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - MANIFESTAZIONI DIVERSE NEL SETTORE SPORTIVO E RICREATIVO' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '03' "/>	
</xsl:call-template>

	
	<xsl:call-template name="ScriviTotale">
		<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
		<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione6"/>
	</xsl:call-template>
	

  </xsl:template>
 
<!-- FINE   FORMATTAZIONE FUNZIONE6 TITOLOI --> 

<!--  FORMATTAZIONE FUNZIONE7 TITOLOI   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione7TitoloI" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
     </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 -SERVIZI TURISTICI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>

</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - MANIFESTAZIONI TURISTICHE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>			

</xsl:call-template>
		
	<xsl:call-template name="ScriviTotale">
		<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
		<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione7"/>
	</xsl:call-template>
	

  </xsl:template>
 
<!-- FINE   FORMATTAZIONE FUNZIONE  7TITOLOI --> 
<!--  FORMATTAZIONE FUNZIONE8 TITOLOI   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione8TitoloI" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloI">
		<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
		<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - VIABILITÁ, CIRCOLAZIONE STRADALE E SERVIZI CONNESSI' "/>
		<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
		<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
		<xsl:with-param name="NumServizio" select=" '01' "/>		
</xsl:call-template>

<xsl:call-template name="FormattaServizioTitoloI">
		<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
		<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - ILLUMINAZIONE PUBBLICA E SERVIZI CONNESSI' "/>
		<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
		<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
		<xsl:with-param name="NumServizio" select=" '02' "/>		
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
		<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
		<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - TRASPORTI PUBBLICI LOCALI E SERVIZI CONNESSI' "/>
		<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3' "/>
		<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
		<xsl:with-param name="NumServizio" select=" '03' "/>		
</xsl:call-template>
	
<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione8"/>
</xsl:call-template>
	

  </xsl:template>
 
<!-- FINE   FORMATTAZIONE FUNZIONE 8TITOLOI --> 


<!--  FORMATTAZIONE FUNZIONE9 TITOLOI   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione9TitoloI" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloI">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - URBANISTICA E GESTIONE DEL TERRITORIO' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '01' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - EDILIZIA RESIDENZIALE PUBBLICA LOCALE E PIANI DI EDILIZIA ECONOMICO-POPOLARE' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '02' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - SERVIZI DI PROTEZIONE CIVILE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '03' "/>			
</xsl:call-template>	
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO4"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 4 - SERVIZIO IDRICO INTEGRATO' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 4 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '04' "/>			
</xsl:call-template>	

<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO5"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 5 - SERVIZIO SMALTIMENTO RIFIUTI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 5' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '05' "/>			
</xsl:call-template>	

<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO6"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 6 - PARCHI E SERVIZI PER LA TUTELA AMBIENTALE DEL VERDE, ALTRI SERVIZI RELATIVI AL TERRITORIO ED ALL´AMBIENTE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 6 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '06' "/>			
</xsl:call-template>	



	<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione9"/>
</xsl:call-template>
  </xsl:template>
 
 
 <!--  FORMATTAZIONE FUNZIONE10 TITOLOI   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione10TitoloI" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloI">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - ASILI NIDO, SERVIZI PER LÁINFANZIA E PER I MINORI' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '01' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - SERVIZI DI PREVENZIONE E RIABILITAZIONE' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '02' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - STRUTTURE RESIDENZIALI E DI RICOVERO PER ANZIANI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '03' "/>			
</xsl:call-template>	
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO4"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 4 - ASSISTENZA, BENEFICENZA PUBBLICA E SERVIZI DIVERSI ALLA PERSONA' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 4 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '04' "/>			
</xsl:call-template>	

<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO5"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 5 - SERVIZIO NECROSCOPICO E CIMITERIALE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 5' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '05' "/>			
</xsl:call-template>	

<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione10"/>
</xsl:call-template>
</xsl:template>

<!--  FORMATTAZIONE FUNZIONE11 TITOLOI   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione11TitoloI" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloI">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - AFFISSIONI E PUBBLICITÁ' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '01' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - FIERE, MERCATI E SERVIZI CONNESSI' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '02' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - MATTATOIO E SERVIZI CONNESSI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '03' "/>			
</xsl:call-template>	
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO4"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 4 - SERVIZI RELATIVI ALL´INDUSTRIA' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 4 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '04' "/>			
</xsl:call-template>	

<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO5"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 5 - SERVIZI RELATIVI AL COMMERCIO' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 5' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '05' "/>			
</xsl:call-template>	

<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO6"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 6 - SERVIZI RELATIVI ALL´ARTIGIANATO' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 6 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '06' "/>			
</xsl:call-template>	
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO7"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 7 - SERVIZI RELATIVI ALL´AGRICOLTURA' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 7 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '07' "/>			
</xsl:call-template>


<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione11"/>
</xsl:call-template>

</xsl:template>

<!--  FORMATTAZIONE FUNZIONE12 TITOLOI   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione12TitoloI" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloI">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - DISTRIBUZIONE GAS' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '01' "/>	
	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - CENTRALE DEL LATTE' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '02' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - DISTRIBUZIONE ENERGIA ELETTRICA' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '03' "/>			
</xsl:call-template>	
<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO4"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 4 - TELERISCALDAMENTO' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 4 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '04' "/>			
</xsl:call-template>	

<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO5"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 5 - FARMACIE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 5' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '05' "/>			
</xsl:call-template>	

<xsl:call-template name="FormattaServizioTitoloI">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO6"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 6 - ALTRI SERVIZI PRODUTTIVI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 6 ' "/>
	<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
	<xsl:with-param name="NumServizio" select=" '06' "/>			
</xsl:call-template>	



	<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione12"/>
</xsl:call-template>
 </xsl:template>




<!-- FINE   FORMATTAZIONE FUNZIONE TITOLOI --> 

<!--***************************-->
<!-- FUNZIONI TITOLO II -->
<!--- FORMATTA SERVIZIO TITOLO II  inizio -->
  <xsl:template name="FormattaServizioTitoloII" >
   <xsl:param name="Servizio" />
   <xsl:param name="NomeServizio" />
   <xsl:param name="TotaleServizio" />
   <xsl:param name="NumFunzione1" />
   <xsl:param name="NumServizio" />   


  <tr valign="bottom">
	  <td class="indent2"> <xsl:value-of select="$NomeServizio"/> </td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    
  </tr> 

  <xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('2' , $NumFunzione1 , $NumServizio , '01 - ACQUISIZIONE DI BENI IMMOBILI') "/>
	<xsl:with-param name="Intervento" select="$Servizio/ACQUISIZIONE_BENI_IMM"/>
	
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('2' , $NumFunzione1 , $NumServizio , '02 - ESPROPRI E SERVITÙ ONEROSE') "/>
	<xsl:with-param name="Intervento" select="$Servizio/ESPROPRI"/>
</xsl:call-template>

<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('2' , $NumFunzione1 , $NumServizio , '03 - ACQUISTO DI BENI SPECIFICI PER REALIZZAZIONI IN ECONOMIA') "/>
	<xsl:with-param name="Intervento" select="$Servizio/ACQUISTO_BENI"/>
</xsl:call-template>

<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('2' , $NumFunzione1 , $NumServizio , '04 - UTILIZZO DI BENI DI TERZI PER REALIZZAZIONI IN ECONOMIA') "/>
	<xsl:with-param name="Intervento" select="$Servizio/UTILIZZO_BENI_TERZI"/>
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('2' , $NumFunzione1 , $NumServizio , '05 - ACQUISIZIONE DI BENI MOBILI, MACCHINE ED ATTREZZATURE TECNICO-SCIENTIFICHE') "/>
	<xsl:with-param name="Intervento" select="$Servizio/ACQUISIZIONI_BENIMOBILI"/>
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('2' , $NumFunzione1 , $NumServizio , '06 - INCARICHI PROFESSIONALI ESTERNI') "/>
	<xsl:with-param name="Intervento" select="$Servizio/INCARICHI_PROFESSIONALI"/>
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('2' , $NumFunzione1 , $NumServizio , '07 - TRASFERIMENTI DI CAPITALE') "/>
	<xsl:with-param name="Intervento" select="$Servizio/TRASFERIMENTI_CAPITALE"/>
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('2' , $NumFunzione1 , $NumServizio , '08 - PARTECIPAZIONI AZIONARIE') "/>
	<xsl:with-param name="Intervento" select="$Servizio/PARTECIPAZIONI_AZIONARIE"/>
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('2' , $NumFunzione1 , $NumServizio , '09 - CONFERIMENTI DI CAPITALE') "/>
	<xsl:with-param name="Intervento" select="$Servizio/CONFERIMENTI_CAPITALE"/>
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('2' , $NumFunzione1 , $NumServizio , '10 - CONCESSIONI DI CREDITI E ANTICIPAZIONI') "/>
	<xsl:with-param name="Intervento" select="$Servizio/CONCESSIONI_CREDITI"/>
</xsl:call-template>
<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleServizio"/>
	<xsl:with-param name="Totale" select="$Servizio/Totale"/>
</xsl:call-template>
</xsl:template>

   <!--- FORMATTA SERVIZIO TITOLO II FINE -->
   
<!--  FORMATTAZIONE FUNZIONE1 TITOLOII   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione1TitoloII" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione"/>
   <xsl:param name="NumFunzione" />
    
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
  <xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - ORGANI ISTITUZIONALI, PARTECIPAZIONE E DECENTRAMENTO' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>			

</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - SEGRETERIA GENERALE, PERSONALE E ORGANIZZAZIONE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>			

</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - GESTIONE ECONOMICA, FINANZIARIA, PROGRAMMAZIONE, PROVVEDITORATO E CONTROLLO DI GESTIONE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '03' "/>			

</xsl:call-template>
	<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO4"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 4 - GESTIONE DELLE ENTRATE TRIBUTARIE E SERVIZI FISCALI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 4 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '04' "/>			

	</xsl:call-template>
	<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO5"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 5 - GESTIONE DEI BENI DEMANIALI E PATRIMONIALI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 5 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '05' "/>			

	</xsl:call-template>
	<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO6"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 6 - UFFICIO TECNICO' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 6 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '06' "/>			

	</xsl:call-template>
	<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO7"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 7 - ANAGRAFE, STATO CIVILE, ELETTORALE, LEVA E SERVIZIO STATISTICO' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 7 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '07' "/>			

	</xsl:call-template>
	<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO8"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 8 - ALTRI SERVIZI GENERALI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 8 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '08' "/>			

	</xsl:call-template>

				
<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione1"/>
</xsl:call-template>
			
			


  </xsl:template>
  
  
  
  
  
   <!--  FORMATTAZIONE FUNZIONE2 TitoloII   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione2TitoloII" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />   
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
     </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloII">
		<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
		<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - UFFICI GIUDIZIARI' "/>
		<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>		

</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
		<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
		<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - CASA CIRCONDARIALE E ALTRI SERVIZI' "/>
		<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>		

</xsl:call-template>
			
<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione2"/>
</xsl:call-template>
	

  </xsl:template>
 
<!-- FINE   FORMATTAZIONE FUNZIONE2 TitoloII --> 


<!--  FORMATTAZIONE FUNZIONE 3 TitoloII   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione3TitoloII" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
     </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - POLIZIA MUNICIPALE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>			

</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - POLIZIA COMMERCIALE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>			

</xsl:call-template>

<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - POLIZIA AMMINISTRATIVA' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '03' "/>			

</xsl:call-template>

	<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione3"/>
</xsl:call-template>
	

  </xsl:template>
 
<!-- FINE   FORMATTAZIONE FUNZIONE3 TitoloII --> 


<!--  FORMATTAZIONE FUNZIONE 4 TitoloII   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione4TitoloII" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - SCUOLA MATERNA' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>			

</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - ISTRUZIONE ELEMENTARE' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>			
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - ISTRUZIONE MEDIA' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '03' "/>			
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO4"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 4 - ISTRUZIONE SECONDARIA SUPERIORE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 4 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '04' "/>			

</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO5"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 5 - ASSISTENZA SCOLASTICA, TRASPORTO, REFEZIONE E ALTRI SERVIZI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 5' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '05' "/>			

</xsl:call-template>


	<xsl:call-template name="ScriviTotale">
		<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
		<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione4"/>
	</xsl:call-template>
	

	

  </xsl:template>
 
<!-- FINE   FORMATTAZIONE FUNZIONE4 TitoloII --> 


<!--  FORMATTAZIONE FUNZIONE 5TitoloII   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione5TitoloII" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - BIBLIOTECHE, MUSEI E PINACOTECHE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>			

</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - TEATRI, ATTIVITA´ CULTURALI E SERVIZI DIVERSI NEL SETTORE CULTURALE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>			

</xsl:call-template>

	
	<xsl:call-template name="ScriviTotale">
		<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
		<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione5"/>
	</xsl:call-template>
	

  </xsl:template>
 
<!-- FINE   FORMATTAZIONE FUNZIONE 5TitoloII --> 

<!--  FORMATTAZIONE FUNZIONE 6TitoloII   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione6TitoloII" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloII">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - PISCINE COMUNALI' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - STADIO COMUNALE, PALAZZO DELLO SPORT ED ALTRI IMPIANTI' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - MANIFESTAZIONI DIVERSE NEL SETTORE SPORTIVO E RICREATIVO' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '03' "/>	
</xsl:call-template>

	
	<xsl:call-template name="ScriviTotale">
		<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
		<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione6"/>
	</xsl:call-template>
	

  </xsl:template>
 
<!-- FINE   FORMATTAZIONE FUNZIONE6 TitoloII --> 

<!--  FORMATTAZIONE FUNZIONE7 TitoloII   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione7TitoloII" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
     </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 -SERVIZI TURISTICI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>			

</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - MANIFESTAZIONI TURISTICHE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>			

</xsl:call-template>
		
	<xsl:call-template name="ScriviTotale">
		<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
		<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione7"/>
	</xsl:call-template>
	

  </xsl:template>
 
<!-- FINE   FORMATTAZIONE FUNZIONE  7TitoloII --> 
<!--  FORMATTAZIONE FUNZIONE8 TitoloII   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione8TitoloII" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloII">
		<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
		<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - VIABILITÁ, CIRCOLAZIONE STRADALE E SERVIZI CONNESSI' "/>
		<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>		
</xsl:call-template>

<xsl:call-template name="FormattaServizioTitoloII">
		<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
		<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - ILLUMINAZIONE PUBBLICA E SERVIZI CONNESSI' "/>
		<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>		
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
		<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
		<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - TRASPORTI PUBBLICI LOCALI E SERVIZI CONNESSI' "/>
		<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '03' "/>		
</xsl:call-template>
	
<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione8"/>
</xsl:call-template>
	

  </xsl:template>
 
<!-- FINE   FORMATTAZIONE FUNZIONE 8TitoloII --> 


<!--  FORMATTAZIONE FUNZIONE9 TitoloII   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione9TitoloII" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloII">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - URBANISTICA E GESTIONE DEL TERRITORIO' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - EDILIZIA RESIDENZIALE PUBBLICA LOCALE E PIANI DI EDILIZIA ECONOMICO-POPOLARE' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - SERVIZI DI PROTEZIONE CIVILE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '03' "/>			
</xsl:call-template>	
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO4"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 4 - SERVIZIO IDRICO INTEGRATO' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 4 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '04' "/>			
</xsl:call-template>	

<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO5"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 5 - SERVIZIO SMALTIMENTO RIFIUTI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 5' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '05' "/>			
</xsl:call-template>	

<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO6"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 6 - PARCHI E SERVIZI PER LA TUTELA AMBIENTALE DEL VERDE, ALTRI SERVIZI RELATIVI AL TERRITORIO ED ALL´AMBIENTE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 6 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '06' "/>			
</xsl:call-template>	



	<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione9"/>
</xsl:call-template>
  </xsl:template>
 
 
 <!--  FORMATTAZIONE FUNZIONE10 TitoloII   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione10TitoloII" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloII">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - ASILI NIDO, SERVIZI PER L´INFANZIA E PER I MINORI' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - SERVIZI DI PREVENZIONE E RIABILITAZIONE' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - STRUTTURE RESIDENZIALI E DI RICOVERO PER ANZIANI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '03' "/>			
</xsl:call-template>	
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO4"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 4 - ASSISTENZA, BENEFICENZA PUBBLICA E SERVIZI DIVERSI ALLA PERSONA' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 4 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '04' "/>			
</xsl:call-template>	

<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO5"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 5 - SERVIZIO NECROSCOPICO E CIMITERIALE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 5' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '05' "/>			
</xsl:call-template>	

<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione10"/>
</xsl:call-template>
</xsl:template>

<!--  FORMATTAZIONE FUNZIONE11 TitoloII   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione11TitoloII" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloII">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - AFFISSIONI E PUBBLICITÁ' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - FIERE, MERCATI E SERVIZI CONNESSI' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - MATTATOIO E SERVIZI CONNESSI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '03' "/>			
</xsl:call-template>	
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO4"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 4 - SERVIZI RELATIVI ALL´INDUSTRIA' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 4 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '04' "/>			
</xsl:call-template>	

<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO5"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 5 - SERVIZI RELATIVI AL COMMERCIO' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 5' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '05' "/>			
</xsl:call-template>	

<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO6"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 6 - SERVIZI RELATIVI ALL´ARTIGIANATO' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 6 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '06' "/>			
</xsl:call-template>	
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO7"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 7 - SERVIZI RELATIVI ALL´AGRICOLTURA' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 7 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '07' "/>			
</xsl:call-template>


<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione11"/>
</xsl:call-template>

</xsl:template>

<!--  FORMATTAZIONE FUNZIONE12 TitoloII   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione12TitoloII" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
  
<xsl:call-template name="FormattaServizioTitoloII">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO1"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 1 - DISTRIBUZIONE GAS' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 1 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '01' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
	<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO2"/>
	<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 2 - CENTRALE DEL LATTE' "/>
	<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 2 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '02' "/>	
</xsl:call-template>
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - DISTRIBUZIONE ENERGIA ELETTRICA' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '03' "/>			
</xsl:call-template>	
<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO4"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 4 - TELERISCALDAMENTO' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 4 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '04' "/>			
</xsl:call-template>	

<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO5"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 5 - FARMACIE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 5' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '05' "/>			
</xsl:call-template>	

<xsl:call-template name="FormattaServizioTitoloII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO6"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 6 - ALTRI SERVIZI PRODUTTIVI' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 6 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '06' "/>			
</xsl:call-template>	



	<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione12"/>
</xsl:call-template>
 </xsl:template>

  
<!-- FINE   FORMATTAZIONE FUNZIONE TitoloII --> 
<!-- ***********************************************-->
<!--*****           INIZIO TITOLO III          ******* -->

<!--- FORMATTA SERVIZIO TITOLO III inizio -->


  <xsl:template name="FormattaServizioTitoloIII" >
   <xsl:param name="Servizio" />
   <xsl:param name="NomeServizio" />
   <xsl:param name="TotaleServizio" />
   <xsl:param name="NumFunzione1" />
   <xsl:param name="NumServizio" />

 <xsl:if test="$Servizio" >

  <tr valign="bottom">
	  <td class="indent2"> <xsl:value-of select="$NomeServizio"/> </td>
  
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
 
  </tr> 

  <xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('3' , $NumFunzione1 , $NumServizio , '01 - RIMBORSO PER ANTICIPAZIONI DI CASSA') "/>
	<xsl:with-param name="Intervento" select="$Servizio/RIMB_ANTICIPAZIONI_CASSA"/>
	
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('3' , $NumFunzione1 , $NumServizio , '02 - RIMBORSO DI FINANZIAMENTI A BREVE TERMINE') "/>
	<xsl:with-param name="Intervento" select="$Servizio/RIMB_FINANZIAMENTI"/>
</xsl:call-template>

<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('3' , $NumFunzione1 , $NumServizio , '03 - RIMBORSO DI QUOTA CAPITALE DI MUTUI E PRESTITI') "/>
	<xsl:with-param name="Intervento" select="$Servizio/RIMB_QUOTACAPITALE_MUTUI"/>
</xsl:call-template>

<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('3' , $NumFunzione1 , $NumServizio , '04 - RIMBORSO DI PRESTITI OBBLIGAZIONARI') "/>
	<xsl:with-param name="Intervento" select="$Servizio/RIMB_PRESTITI_OBBL"/>
</xsl:call-template>
<xsl:call-template name="ScriviIntervento">
	<xsl:with-param name="NomeIntervento" select=" concat('3' , $NumFunzione1 , $NumServizio , '05 - RIMBORSO DI QUOTA CAPITALE DI DEBITI PLURIENNALI') "/>
	<xsl:with-param name="Intervento" select="$Servizio/RIMB_QUOTACAPITALE_DEBITI"/>
</xsl:call-template>
<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleServizio"/>
	<xsl:with-param name="Totale" select="$Servizio/Totale"/>
</xsl:call-template>

</xsl:if>
</xsl:template>

   <!--- FORMATTA SERVIZIO TITOLOIII FINE -->

<!--  FORMATTAZIONE FUNZIONE1 TitoloIII   : Formatta la Funzione con i servizi ed i relativi interventi
 INPUT :  Funzione = nome nodo della Funzione da formattare
 		NomeFunzione = descrizione del nodo funzione che deve comparire in visualizzazione
 		Totale Funzione = descrizione del totale della funzione che deve comparire in visualizzazione  -->
 
  
<xsl:template name="FormattaFunzione1TitoloIII" >

   <xsl:param name="Funzione" />     
   <xsl:param name="NomeFunzione" />
   <xsl:param name="TotaleFunzione" />
   <xsl:param name="NumFunzione" />
   
  <tr valign="bottom"> 
    <td class="indent1"><xsl:value-of select="$NomeFunzione"/></td>
    <td align="center">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
      </tr>
  
 
<xsl:call-template name="FormattaServizioTitoloIII">
			<xsl:with-param name="Servizio" select="$Funzione/SERVIZIO3"/>
			<xsl:with-param name="NomeServizio" select=" 'SERVIZIO 3 - GESTIONE ECONOMICA, FINANZIARIA, PROGRAMMAZIONE, PROVVEDITORATO E CONTROLLO DI GESTIONE' "/>
			<xsl:with-param name="TotaleServizio" select=" 'TOTALE SERVIZIO 3 ' "/>
			<xsl:with-param name="NumFunzione1" select=" $NumFunzione "/>
			<xsl:with-param name="NumServizio" select=" '03' "/>			

</xsl:call-template>
					
<xsl:call-template name="ScriviTotale">
	<xsl:with-param name="NomeTotale" select="$TotaleFunzione"/>
	<xsl:with-param name="Totale" select="$Funzione/TotaleFunzione1"/>
</xsl:call-template>
	
  </xsl:template>
  
<!-- FINE TITOLO III -->



<xsl:template name="RigaBianca" >	   
<tr valign="bottom"> 
	   <td align="center">&nbsp;</td>
	  <td align="right">&nbsp;</td>
	   <td align="right">&nbsp;</td>
	  <td align="right">&nbsp;</td>
	  <td align="right">&nbsp;</td>
	  <td align="right">&nbsp;</td>
	  <td align="right">&nbsp;</td>
	  <td align="right">&nbsp;</td>

</tr>
 </xsl:template>


 


</xsl:stylesheet>
