<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:variable name="this" select="/"/>
	<xsl:decimal-format name="european" decimal-separator="," grouping-separator="."/>
	<xsl:template match="/">
		<html>
			<head>
				<title>CONTO DEL PATRIMONIO PER COMUNI</title>
				<style type="text/css">td { font-family: tahoma; font-size: 7pt; color: #000000; font-weight: normal;}
td.intest { font-size: 9pt;}
table.tabella1 { width: 850px; border-collapse: collapse; border-width: 0}
td.indent1 {padding-left: 15px}
td.indent2 {padding-left: 30px}
td.indent3 {padding-left: 45px}
td.indent4 {padding-left: 75px}
td.stampa1 { width: 84px }
td.barra { border-bottom: 2px solid #000000}</style>
				<style media="print" type="text/css">td { font-family: tahoma; font-size: 5pt; color: #000000; }
table.tabella1 { width: 700px }
td.stampa1 { width: 64px }</style>
			</head>
			<body bgcolor="#FFFFFF" text="#000000">
				<xsl:apply-templates select="//cpapatrimonio  /Copertina"/>
				<table border="0" cellspacing="0" cellpadding="3" class="tabella1">
					<tr>
						<td align="center">
							<b>CONTO DEL PATRIMONIO (ATTIVO)</b>
						</td>
					</tr>
				</table>
				<table class="tabella1" border="1" cellspacing="0" cellpadding="2" bordercolor="#000000">
					<tr>
						<td align="center" rowspan="2">&nbsp;</td>
						<td align="center" class="stampa1" rowspan="2">IMPORTI PARZIALI</td>
						<td align="center" valign="middle" class="stampa1" rowspan="2">CONSISTENZA INIZIALE</td>
						<td align="center" colspan="2">VARIAZIONI DA C/FINANZIARIO</td>
						<td align="center" colspan="2">VARIAZIONI DA ALTRE CAUSE</td>
						<td align="center" class="stampa1" rowspan="2">CONSISTENZA FINALE</td>
					</tr>
					<tr>
						<td align="center" class="stampa1">+</td>
						<td align="center" class="stampa1">-</td>
						<td align="center" valign="middle" class="stampa1">+</td>
						<td align="center" class="stampa1">-</td>
					</tr>
					<tr>
						<td>
							<b>A)
                <u>IMMOBILIZZAZIONI</u>
							</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent1">I)
              <u>IMMOBILIZZAZIONI IMMATERIALI</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent2">1) Costi pluriennali capitalizzati</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Immateriali/CostiPluriennali"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Immateriali/CostiPluriennali/ImportiParziali/ValoreLordo"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">(relativo fondo di ammortamento in detrazione)</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Immateriali/CostiPluriennali/ImportiParziali/FondoAmmortamento"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Immateriali/CostiPluriennali/ImportiParziali/FondoAmmortamento"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td align="right">
							<b>TOTALE</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Immateriali/Totale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent1">II)
              <u>IMMOBILIZZAZIONI MATERIALI</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent2">1) Beni demaniali</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/BeniDemaniali"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/BeniDemaniali/ImportiParziali/ValoreLordo"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">(relativo fondo di ammortamento in detrazione)</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/BeniDemaniali/ImportiParziali/FondoAmmortamento"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/BeniDemaniali/ImportiParziali/FondoAmmortamento"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">2) Terreni (patrimonio indisponibile)</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/TerreniIndisponibili"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">3) Terreni (patrimonio disponibile)</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/TerreniDisponibili"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">4) Fabbricati (patrimonio indisponibile)</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/FabbricatiIndisponibili"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/FabbricatiIndisponibili/ImportiParziali/ValoreLordo"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">(relativo fondo di ammortamento in detrazione)</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/FabbricatiIndisponibili/ImportiParziali/FondoAmmortamento"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/FabbricatiIndisponibili/ImportiParziali/FondoAmmortamento"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">5) Fabbricati (patrimonio disponibile)</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/FabbricatiDisponibili"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/FabbricatiDisponibili/ImportiParziali/ValoreLordo"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">(relativo fondo di ammortamento in detrazione)</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/FabbricatiDisponibili/ImportiParziali/FondoAmmortamento"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/FabbricatiDisponibili/ImportiParziali/FondoAmmortamento"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">6) Macchinari, attrezzature ed impianti</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/Macchinari"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/Macchinari/ImportiParziali/ValoreLordo"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">(relativo fondo di ammortamento in detrazione)</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/Macchinari/ImportiParziali/FondoAmmortamento"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/Macchinari/ImportiParziali/FondoAmmortamento"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">7) Attrezzature e sistemi informatici</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/Attrezzature"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/Attrezzature/ImportiParziali/ValoreLordo"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">(relativo fondo di ammortamento in detrazione)</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/Attrezzature/ImportiParziali/FondoAmmortamento"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/Attrezzature/ImportiParziali/FondoAmmortamento"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">8) Automezzi e motomezzi</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/AutoMotoMezzi"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/AutoMotoMezzi/ImportiParziali/ValoreLordo"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">(relativo fondo di ammortamento in detrazione)</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/AutoMotoMezzi/ImportiParziali/FondoAmmortamento"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/AutoMotoMezzi/ImportiParziali/FondoAmmortamento"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">9) Mobili e macchine d'ufficio</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/MobiliMacchineUff"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/MobiliMacchineUff/ImportiParziali/ValoreLordo"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">(relativo fondo di ammortamento in detrazione)</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/MobiliMacchineUff/ImportiParziali/FondoAmmortamento"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/MobiliMacchineUff/ImportiParziali/FondoAmmortamento"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">10) Universalitàdi beni (patrimonio indisponibile)</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/UniversalitaBeniIndisponibili"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/UniversalitaBeniIndisponibili/ImportiParziali/ValoreLordo"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">(relativo fondo di ammortamento in detrazione)</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/UniversalitaBeniIndisponibili/ImportiParziali/FondoAmmortamento"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/UniversalitaBeniIndisponibili/ImportiParziali/FondoAmmortamento"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">11) Universalitàdi beni (patrimonio disponibile)</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/UniversalitaBeniDisponibili"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/UniversalitaBeniDisponibili/ImportiParziali/ValoreLordo"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">(relativo fondo di ammortamento in detrazione)</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/UniversalitaBeniDisponibili/ImportiParziali/FondoAmmortamento"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Materiali/UniversalitaBeniDisponibili/ImportiParziali/FondoAmmortamento"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">12) Diritti reali su beni di terzi</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/Diritti"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">13) Immobilizzazioni in corso</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/ImmobilizzazioniInCorso"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td align="right">
							<b>TOTALE</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Materiali/Totale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent1">III)
              <u>IMMOBILIZZAZIONI FINANZIARIE</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent2">1) Partecipazioni in:</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent3">a) Imprese controllate</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Finanziarie/Partecipazioni/ImpreseControllate"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent3">b) Imprese collegate</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Finanziarie/Partecipazioni/ImpreseCollegate"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent3">c) Altre imprese</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Finanziarie/Partecipazioni/ImpreseAltre"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">2) Crediti verso:</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent3">a) Imprese controllate</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Finanziarie/Crediti/ImpreseControllate"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent3">b) Imprese collegate</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Finanziarie/Crediti/ImpreseCollegate"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent3">c) Altre imprese</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Finanziarie/Crediti/ImpreseAltre"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">3) Titoli (investimenti a medio e lungo termine)</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Finanziarie/Titoli"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">4) Crediti di dubbia esigibilità</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Finanziarie/CreditiDubbiaEsi"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Finanziarie/CreditiDubbiaEsi/ImportiParziali/ValoreLordo"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">(detratto il fondo svalutazione crediti)</td>
						<xsl:call-template name="TuttiNodiOpzionali">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Finanziarie/CreditiDubbiaEsi/ImportiParziali/FondoAmmortamento"/>
							<xsl:with-param name="NodoAmm" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Finanziarie/CreditiDubbiaEsi/ImportiParziali/FondoAmmortamento"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">5) Crediti per depositi cauzionali</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio/CpatrimonioAttivo/Immobilizzazioni/Finanziarie/CreditiDepositoCauz"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td align="right">
							<b>TOTALE</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Finanziarie/Totale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent3">
							<b>TOTALE IMMOBILIZZAZIONI</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/Immobilizzazioni/Totale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td>
							<b>B)
                <u>ATTIVO CIRCOLANTE</u>
							</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent1">I)
              <u>RIMANENZE</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td align="right">
							<b>TOTALE</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Rimanenze/Totale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent1">II)
              <u>CREDITI</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent2">1) Verso contribuenti</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/Contribuenti"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">2) Verso enti del sett. pubblico allargato:</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent3">a) Stato - correnti</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/EntiPubblici/Stato/Correnti"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent4">- capitale</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/EntiPubblici/Stato/Capitale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent3">b) Regione - correnti</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/EntiPubblici/Regione/Correnti"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent4">- capitale</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/EntiPubblici/Regione/Capitale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent3">c) Altri - correnti</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/EntiPubblici/Altri/Correnti"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent4">- capitale</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/EntiPubblici/Altri/Capitale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">3) Verso debitori diversi:</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent3">a) verso utenti di servizi pubblici</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/DebitiDiversi/UtentiServizi"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent3">b) verso utenti di beni patrimoniali</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/DebitiDiversi/UtentiBeni"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent3">c) verso altri - correnti</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/DebitiDiversi/Altri/Correnti"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent4">- capitale</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/DebitiDiversi/Altri/Capitale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent3">d) da alienazioni patrimoniali</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/DebitiDiversi/Alienazioni"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent3">e) per somme corrisposte c/terzi</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/DebitiDiversi/Somme"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">4) Crediti per IVA</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/CreditiIva"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">5) Per depositi</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent3">a) banche</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/Depositi/Banche"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent3">b) Cassa Depositi e Prestiti</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/Depositi/CassaDepositiPrestiti"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td align="right">
							<b>TOTALE</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Crediti/Totale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent1">III)
              <u>ATTIVITA' FINANZIARIE CHE NON COSTITUISCONO IMMOBILIZZI</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent2">1) Titoli</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/AttivitaFinanziarie/Titoli"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td align="right">
							<b>TOTALE</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/AttivitaFinanziarie/Totale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent1">IV)
              <u>DISPONIBILITA' LIQUIDE</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent2">1) Fondo di cassa</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Disponibilita/FondoCassa"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">2) Depositi bancari</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Disponibilita/DepositiBancari"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td align="right">
							<b>TOTALE</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Disponibilita/Totale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent3">
							<b>TOTALE ATTIVO CIRCOLANTE</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/AttivoCircolante/Totale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td>
							<b>C)
                <u>RATEI E RISCONTI</u>
							</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent1">I)
              <u>RATEI ATTIVI</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/RateiRisconti/Ratei"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent1">II)
              <u>RISCONTI ATTIVI</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/RateiRisconti/Risconti"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td align="right">
							<b>TOTALE RATEI E RISCONTI</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/RateiRisconti/Totale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">
							<b>TOTALE DELL'ATTIVO (A+B+C)</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/TotAttivo"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent2">CONTI D'ORDINE</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td>
							<b>D)
                <u>OPERE DA REALIZZARE</u>
							</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/ContiOrdine/Opere"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td>
							<b>E)
                <u>BENI CONFERITI IN AZIENDE SPECIALI</u>
							</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/ContiOrdine/Beni"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td>
							<b>F)
                <u>BENI DI TERZI</u>
							</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/ContiOrdine/BeniTerzi"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td align="right">
							<b>TOTALE CONTI D'ORDINE</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioAttivo/ContiOrdine/Totale"/>
						</xsl:call-template>
					</tr>
				</table>
				<table border="0" cellspacing="0" cellpadding="3" class="tabella1">
					<tr>
						<td align="center">
							<b>CONTO DEL PATRIMONIO (PASSIVO)</b>
						</td>
					</tr>
				</table>
				<table class="tabella1" border="1" cellspacing="0" cellpadding="2" bordercolor="#000000">
					<tr>
						<td align="center" rowspan="2">&nbsp;</td>
						<td align="center" class="stampa1" rowspan="2">IMPORTI PARZIALI</td>
						<td align="center" valign="middle" class="stampa1" rowspan="2">CONSISTENZA INIZIALE</td>
						<td align="center" colspan="2">VARIAZIONI DA C/FINANZIARIO</td>
						<td align="center" colspan="2">VARIAZIONI DA ALTRE CAUSE</td>
						<td align="center" class="stampa1" rowspan="2">CONSISTENZA FINALE</td>
					</tr>
					<tr>
						<td align="center" class="stampa1">+</td>
						<td align="center" class="stampa1">-</td>
						<td align="center" valign="middle" class="stampa1">+</td>
						<td align="center" class="stampa1">-</td>
					</tr>
					<tr>
						<td>
							<b>A)
                <u>PATRIMONIO NETTO</u>
							</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent1">I)
              <u>NETTO PATRIMONIALE</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/PatrimonioNetto/NettoPatrimoniale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent1">II)
              <u>NETTO DA BENI DEMANIALI</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/PatrimonioNetto/NettoBeniDemaniali"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td align="right">
							<b>TOTALE PATRIMONIO NETTO</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/PatrimonioNetto/Totale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td>
							<b>B)
                <u>CONFERIMENTI</u>
							</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent1">I)
              <u>CONFERIMENTI DA TRASFERIMENTI IN CONTO CAPITALE</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/Conferimenti/ConferimentiTrasferimenti"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent1">II)
              <u>CONFERIMENTI DA CONCESSIONI DI EDIFICARE</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/Conferimenti/ConferimentiConcessioni"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td align="right">
							<b>TOTALE CONFERIMENTI</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/Conferimenti/Totale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td>
							<b>C)
                <u>DEBITI</u>
							</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent1">I)
              <u>DEBITI DI FINANZIAMENTO</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent2">
							<span class="indent2">1) Per finanziamenti a breve termine</span>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/Debiti/DebitiFinanziamento/BreveTermine"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">
							<span class="indent2">2) Per mutui e prestiti</span>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/Debiti/DebitiFinanziamento/Mutui"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">
							<span class="indent2">3) Per prestiti obbligazionari</span>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/Debiti/DebitiFinanziamento/Prestiti"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">
							<span class="indent2">4) Per debiti pluriennali</span>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/Debiti/DebitiFinanziamento/DebitiPluriennali"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent1">II)
              <u>DEBITI DI FUNZIONAMENTO</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/Debiti/DebitiFunzionamento"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent1">III)
              <u>DEBITI PER IVA</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/Debiti/DebitiIva"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent1">IV)
              <u>DEBITI PER ANTICIPAZIONI DI CASSA</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/Debiti/DebitiCassa"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent1">V)
              <u>DEBITI PER SOMME ANTICIPATE DA TERZI</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/Debiti/DebitiSomme"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent1">VI)
              <u>DEBITI VERSO</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent2">
							<span class="indent2">1) Imprese controllate</span>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/Debiti/DebitiVerso/ImpreseControllate"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">
							<span class="indent2">2) Imprese collegate</span>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/Debiti/DebitiVerso/ImpreseCollegate"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">
							<span class="indent2">3) Altri (aziende speciali, consorzi, istituzioni)</span>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/Debiti/DebitiVerso/ImpreseAltre"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent1">VII)
              <u>ALTRI DEBITI</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/Debiti/DebitiAltri"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td align="right">
							<b>TOTALE DEBITI</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/Debiti/Totale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td>
							<b>D)
                <u>RATEI E RISCONTI</u>
							</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent1">I)
              <u>RATEI PASSIVI</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/RateiRisconti/Ratei"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent1">II)
              <u>RISCONTI PASSIVI</u>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/RateiRisconti/Risconti"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td align="right">
							<b>TOTALE RATEI E RISCONTI</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/RateiRisconti/Totale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td class="indent2">
							<b>TOTALE DEL PASSIVO (A+B+C+D)</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/TotPassivo"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td class="indent2">CONTI D'ORDINE</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<td align="right" valign="bottom">&nbsp;</td>
					</tr>
					<tr>
						<td>
							<b>E)
                <u>IMPEGNI OPERE DA REALIZZARE</u>
							</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/ContiOrdinePassivo/Impegni"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td>
							<b>F)
                <u>CONFERIMENTI IN AZIENDE SPECIALI</u>
							</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/ContiOrdinePassivo/ConferimentiContoOrdine"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td>
							<b>G)
                <u>BENI DI TERZI</u>
							</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/ContiOrdinePassivo/BeniTerzi"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td align="right">
							<b>TOTALE CONTI D'ORDINE</b>
						</td>
						<td align="right" valign="bottom">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//cpapatrimonio /CpatrimonioPassivo/ContiOrdinePassivo/Totale"/>
						</xsl:call-template>
					</tr>
				</table>
				<table width="640" border="0" cellspacing="0" cellpadding="5">
					<tr>
						<td colspan="2">
							<p>&nbsp;</p>
							<p>--------------------------------------------------------------------------, li --------------------------</p>
							<p>&nbsp;</p>
						</td>
					</tr>
					<tr>
						<td align="center" width="264">IL SEGRETARIO
              <p>------------------------</p>
						</td>
						<td align="center" width="356">
							<p>IL RESPONSABILE DEL SERVIZIO FINANZIARIO</p>
							<p>--------------------------------------------------------------------------</p>
						</td>
					</tr>
					<tr>
						<td colspan="2" align="center">
							<p>IL LEGALE RAPPRESENTANTE DELL'ENTE</p>
							<p>----------------------------------------------</p>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="Copertina">
		<table width="100%" border="0" cellspacing="0" cellpadding="3">
			<tr>
				<td align="center" colspan="3" class="intest">
					<p>
						<b><br/>
						</b>
						<b><br/>
						</b>
					</p>
				</td>
			</tr>
			<tr>
				<td width="290">ESERCIZIO: <xsl:value-of select="//Copertina/Esercizio"/> </td>
			    <td width="466">ENTE: <xsl:value-of select="//Copertina/NomeEnte"/></td>
			    <td width="229">SIGLA PROVINCIA: <xsl:value-of select="//Copertina/Provincia"/></td>
			  </tr>
			  <tr> 
			    <td width="290">CODICE ISTAT: <xsl:value-of select="//Copertina/CodiceIstat"/>
			</td>
			    <td width="466">DELIBERA DI APPROVAZIONE: N°<xsl:value-of select="//Copertina/NumDelibera"/></td>
			    <xsl:variable name="abitanti"  select ="//Copertina/NumAbitanti" />
			    <td width="229">NUMERO DI ABITANTI: <xsl:value-of select ="format-number ($abitanti, '#.###.###.###.###.##0', 		'european') 	"/>
			    </td>
			  </tr>
			  <tr> 
			    <td width="290">PARTITA IVA: <xsl:value-of select="//Copertina/PartitaIVA"/></td>
			    <td width="466">DEL: <xsl:value-of select="//Copertina/DataDelibera/Giorno"/>/<xsl:value-of 			select="//Copertina/DataDelibera/Mese"/>/<xsl:value-of select="//Copertina/DataDelibera/Anno"/></td>
			    	
			    <xsl:variable name="superficie"  select ="//Copertina/Superficie" />
			    <td width="229">
			    SUPERFICIE (kmq): <xsl:value-of select ="//Copertina/Superficie"/>
		    </td>

			</tr>
		</table>
		<br/>
	</xsl:template>
	<xsl:template name="formatto">
		<xsl:param name="Importo"/>
		<td align="right" valign="bottom">
			<xsl:value-of select="translate(format-number (number(translate($Importo,  ','  , '.' )),'#.###.###.###.###.##0,00', 'european'),'NaN','') "/>
		</td>
	</xsl:template>
	<xsl:template name="TuttiNodi">
		<xsl:param name="Nodo"/>
		<xsl:for-each select="$Nodo/child::node()">
			<xsl:call-template name="formatto">
				<xsl:with-param name="Importo">
					<xsl:value-of select="current()"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="TuttiNodiOpzionali">
		<xsl:param name="Nodo"/>
		<xsl:param name="NodoAmm"/>
		<xsl:param name="NumColonne" select="count($Nodo/child::node())"/>
		<xsl:if test="$NodoAmm!=''">
			<xsl:call-template name="formatto">
				<xsl:with-param name="Importo">
					<xsl:value-of select="$NodoAmm"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$NumColonne!=1">
 		<xsl:for-each select="$Nodo/child::node()">
				<xsl:if test="position()=1 and name()!='ImportiParziali'">
					<td align="right" valign="bottom">&nbsp;</td>
				</xsl:if>
				<xsl:if test="name()!='ImportiParziali'">
				<xsl:call-template name="formatto">
					<xsl:with-param name="Importo">
						<xsl:value-of select="current()"/>
					</xsl:with-param>
				</xsl:call-template>
				</xsl:if>
		</xsl:for-each>
		</xsl:if>
		
		<xsl:if test="$NumColonne=1 or $NumColonne=0">
			<xsl:if test="$NumColonne=0">
				<td align="right" valign="bottom">&nbsp;</td>
			</xsl:if>
			<td align="right" valign="bottom">&nbsp;</td>
			<td align="right" valign="bottom">&nbsp;</td>
			<td align="right" valign="bottom">&nbsp;</td>
			<td align="right" valign="bottom">&nbsp;</td>
			<td align="right" valign="bottom">&nbsp;</td>
			<td align="right" valign="bottom">&nbsp;</td>
		</xsl:if>
		
		
	</xsl:template>
</xsl:stylesheet>